%% Script for plotting
%{
Add the folder containing this script file to MATLAB path, and then paste the file path to the
variable 'BasePath'. All required third party functions should also be in this folder.
Place the source data files for this figure into the same folder as this script.
Tested with MATLAB R2015a. Requires the Statistics and Machine Learning Toolbox (and the code in 
this folder).
%}

%% Initial Plot/Figure Settings

set(groot,'DefaultFigureColor',[1 1 1]);
set(groot,'DefaultFigureWindowStyle','docked');
set(groot,'DefaultAxesFontSize',24);
set(groot,'DefaultTextFontSize',24);
set(groot,'DefaultAxesColor','none');
set(groot,'DefaultAxesXColor',[0,0,0]);
set(groot,'DefaultAxesYColor',[0,0,0]);
set(groot,'DefaultAxesZColor',[0,0,0]);
set(groot,'DefaultAxesLineWidth',2);
set(groot,'DefaultAxesTickLength',0.015+[0,0]);
set(groot,'DefaultAxesTickDir','out');
set(groot,'DefaultAxesTickDirMode','manual');
set(groot,'DefaultLineLineWidth',1);

%% Load Input Data

BasePath = '';
if isempty(BasePath)
    BasePath = fileparts(mfilename('fullpath'));
    if isempty(BasePath)
        BasePath = pwd;
    end
end

I = readtable(fullfile(BasePath,'20190312_wt_PAO1_SH_reporter_background_subtracted_fluorescence_per_cell.xlsx'));

%% Fig. 1 - S4,S5: stat test for fluorescence

I_med = cellfun(@(n)median(I.(n)(isfinite(I.(n)))),I.Properties.VariableNames);
I_med_bootstrap = cellfun(@(n)bootstrp(1e4,@median,I.(n)(isfinite(I.(n)))),I.Properties.VariableNames,'un',0);
I_med_ci = cellfun(@(n)bootci(1e4,@median,I.(n)(isfinite(I.(n)))),I.Properties.VariableNames,'un',0);


[ksd_y,ksd_x] = cellfun(@ksdensity,I_med_bootstrap,'un',0);

patch_x = cellfun(@(x) [-x, x(end:-1:1)]./max(x(:)).*0.49, ksd_y, 'un',0);
patch_x = cellfun(@(n,x) n+x, num2cell(1:numel(patch_x)), patch_x, 'un',0);
patch_y = cellfun(@(y) [y, y(end:-1:1)], ksd_x, 'un',0);

FigureHandle = figure('NumberTitle','off','Name','Bootstrap Single Cell Median Intensities');
AxisHandle = axes('parent',FigureHandle,'NextPlot','add','Color','none','XColor','k','YColor','k','ZColor','k','LineWidth',2,'TickLength',0.015+[0,0],'TickDir','out','PlotBoxAspectRatio',[1,1,1]);

PatchHandle = cellfun(@(x,y)patch(x,y,0.75+[0,0,0],'Parent',AxisHandle,'EdgeColor','none'),patch_x,patch_y,'un',0);

UpperHandle = cellfun(@(x,ci)plot(x+0.2.*[-1,1],ci(2)+[0,0],'k-','LineWidth',1,'Parent',AxisHandle),num2cell(1:numel(I_med_ci)),I_med_ci,'un',0);
LowerHandle = cellfun(@(x,ci)plot(x+0.2.*[-1,1],ci(1)+[0,0],'k-','LineWidth',1,'Parent',AxisHandle),num2cell(1:numel(I_med_ci)),I_med_ci,'un',0);
MiddleHandle = arrayfun(@(x,y)plot(x+0.4.*[-1,1],y+[0,0],'k-','LineWidth',1,'Parent',AxisHandle),1:numel(I_med_ci),I_med,'un',0);
CiHandle = cellfun(@(x,ci)plot(x+[0,0],ci,'k-','LineWidth',1,'Parent',AxisHandle),num2cell(1:numel(I_med_ci)),I_med_ci,'un',0);
set([UpperHandle{:},LowerHandle{:},MiddleHandle{:},CiHandle{:}],'LineWidth',1);
set([MiddleHandle{:}],'LineWidth',1.5);

set(AxisHandle,'XTick',1:numel(I_med_ci),'XTickLabel',[arrayfun(@(n)sprintf('%g h',n),0:2:12,'un',0),{'vc'}]);
set(AxisHandle,'XLim',[1,numel(I_med_ci)]+0.5.*[-1,1],'XGrid','on','GridLineStyle','--');

ylabel(AxisHandle,'GFP fluorescence');

