%% Script for plotting
%{
Add the folder containing this script file to MATLAB path, and then paste the file path to the
variable 'BasePath'. All required third party functions should also be in this folder.
Place the source data files for this figure into the same folder as this script.
Tested with MATLAB R2015a. Requires the Statistics and Machine Learning Toolbox (and the code in 
this folder).
%}

%% Initial Plot/Figure Settings

set(groot,'DefaultFigureColor',[1 1 1]);
set(groot,'DefaultFigureWindowStyle','docked');
set(groot,'DefaultAxesFontSize',24);
set(groot,'DefaultTextFontSize',24);
set(groot,'DefaultAxesColor','none');
set(groot,'DefaultAxesXColor',[0,0,0]);
set(groot,'DefaultAxesYColor',[0,0,0]);
set(groot,'DefaultAxesZColor',[0,0,0]);
set(groot,'DefaultAxesLineWidth',2);
set(groot,'DefaultAxesTickLength',0.015+[0,0]);
set(groot,'DefaultAxesTickDir','out');
set(groot,'DefaultAxesTickDirMode','manual');
set(groot,'DefaultLineLineWidth',1);

%% Load Input Data

BasePath = '';
if isempty(BasePath)
    BasePath = fileparts(mfilename('fullpath'));
    if isempty(BasePath)
        BasePath = pwd;
    end
end

load(fullfile(BasePath,'RegularData.mat'),'RegularData');
load(fullfile(BasePath,'DwspRData.mat'),'DwspRData');

%% Fig. 4b: I_cdGMP vs F_motile

FigureHandle = figure('NumberTitle','off','Name','Fig. 4b: I_cdGMP vs F_motile');
AxisHandle = axes('parent',FigureHandle);
set(AxisHandle,'NextPlot','add','Color','none','XColor','k','YColor','k','LineWidth',2,'TickLength',0.025+[0,0],'TickDir','out');

Data = [[RegularData.F_motile];[RegularData.I_cdGMP]]';

plot(Data(:,1),Data(:,2),'parent',AxisHandle,'LineWidth',2,'MarkerSize',15,'LineStyle','none','Marker','o','MarkerEdgeColor','k','MarkerFaceColor',0.75+[0,0,0]);

[~,D,X,Y] = kde2d(Data,2^8,[0,0],[0.4,1]);
dX = X(1,2)-X(1,1);
dY = Y(2,1)-Y(1,1);

[DS,DSidx] = sort(D(:),'descend');
[~,Didx] = sort(DSidx,'ascend');
CumDS = cumsum(DS.*dX.*dY);
CumDS = CumDS ./ max(CumDS);
CumD = reshape(CumDS(Didx),size(D));

[~,ContourHandle] = contour(AxisHandle,X,Y,CumD,'Fill','off','LineStyle','-','LineWidth',2.1,'Color',0.5+[0,0,0],'parent',AxisHandle);
ContourHandle = [ContourHandle; copyobj(ContourHandle,AxisHandle)];
uistack(ContourHandle,'bottom');
set(ContourHandle(1),'LevelList',0.95,'LineStyle','-');
set(ContourHandle(2),'LevelList',0.5,'LineStyle','--');

[rho,pval] = corr(Data(:,1),Data(:,2),'type','spearman');

text(0.95,0.95,{sprintf('\\rho = %0.3g',rho),sprintf('p-val = %0.2g',pval),''},'units','normalized','parent',AxisHandle,...
    'HorizontalAlignment','right','VerticalAlignment','top','clipping','off','Rotation',0);

set(AxisHandle,'XLim',[0,0.4],'XTick',0:0.1:0.4);
set(AxisHandle,'YLim',[0,1],'YTick',0:.25:1);
set(AxisHandle,'PlotBoxAspectRatio',[1,1,1]);

xlabel(AxisHandle,'F_{motile}');
ylabel(AxisHandle,'I_{c-di-GMP}');

Idx = [25,12,21];
for n1 = 1:numel(Idx)
    text(Data(Idx(n1),1)+diff(get(AxisHandle,'XLim')).*0.015,Data(Idx(n1),2)+diff(get(AxisHandle,'YLim')).*0.015,sprintf('%g',n1),'units','data','parent',AxisHandle,...
        'HorizontalAlignment','left','VerticalAlignment','bottom','clipping','off','Rotation',0);
end

%% Fig. 4c: I_cdGMP vs TreeAsym

FigureHandle = figure('NumberTitle','off','Name','Fig. 4c: I_cdGMP vs TreeAsym');
AxisHandle = axes('parent',FigureHandle);
set(AxisHandle,'NextPlot','add','Color','none','XColor','k','YColor','k','LineWidth',2,'TickLength',0.025+[0,0],'TickDir','out');

Data = [[RegularData.TreeAsym];[RegularData.I_cdGMP]]';

plot(Data(:,1),Data(:,2),'parent',AxisHandle,'LineWidth',2,'MarkerSize',15,'LineStyle','none','Marker','o','MarkerEdgeColor','k','MarkerFaceColor',0.75+[0,0,0]);

[~,D,X,Y] = kde2d(Data,2^8,[0,0],[1,1]);
dX = X(1,2)-X(1,1);
dY = Y(2,1)-Y(1,1);

[DS,DSidx] = sort(D(:),'descend');
[~,Didx] = sort(DSidx,'ascend');
CumDS = cumsum(DS.*dX.*dY);
CumDS = CumDS ./ max(CumDS);
CumD = reshape(CumDS(Didx),size(D));

[~,ContourHandle] = contour(AxisHandle,X,Y,CumD,'Fill','off','LineStyle','-','LineWidth',2.1,'Color',0.5+[0,0,0],'parent',AxisHandle);
ContourHandle = [ContourHandle; copyobj(ContourHandle,AxisHandle)];
uistack(ContourHandle,'bottom');
set(ContourHandle(1),'LevelList',0.95,'LineStyle','-');
set(ContourHandle(2),'LevelList',0.5,'LineStyle','--');

[rho,pval] = corr(Data(:,1),Data(:,2),'type','spearman');

text(0.95,0.95,{sprintf('\\rho = %0.3g',rho),sprintf('p-val = %0.2g',pval),''},'units','normalized','parent',AxisHandle,...
    'HorizontalAlignment','right','VerticalAlignment','top','clipping','off','Rotation',0);

set(AxisHandle,'XLim',[0,1],'XTick',0:.25:1);
set(AxisHandle,'YLim',[0,1],'YTick',0:.25:1);
set(AxisHandle,'PlotBoxAspectRatio',[1,1,1]);

xlabel(AxisHandle,'Tree Asymmetry \lambda');
ylabel(AxisHandle,'I_{c-di-GMP}');

Idx = [25,12,21];
for n1 = 1:numel(Idx)
    text(Data(Idx(n1),1)+diff(get(AxisHandle,'XLim')).*0.015,Data(Idx(n1),2)+diff(get(AxisHandle,'YLim')).*0.015,sprintf('%g',n1),'units','data','parent',AxisHandle,...
        'HorizontalAlignment','left','VerticalAlignment','bottom','clipping','off','Rotation',0);
end

%% Fig. 4d: 2D family tree plots

Idx = [25,12,21];

FigureHandle = figure('NumberTitle','off','Name','Fig. 4d: 2D family tree plots');

AxisHandle = arrayfun(@(n) plotGenealogyTree_BranchList(RegularData(Idx(n)).BranchList,'tUnitConversion',1/3600,'TimeOffset',0,...
    'DetachMarker','>','DisplayName',sprintf('Regular Family %d',n)), 1:numel(Idx));

ColorOrder = [
    198,168,92
    30,165,138
    9,106,200
    ]./255;

arrayfun(@(n)set([AxisHandle(n).VertLineHandle.Node{:}],'Color',ColorOrder(n,:)),1:numel(AxisHandle));
arrayfun(@(n)set([AxisHandle(n).HorzLineHandle.Node{:}],'Color','k'),1:numel(AxisHandle));
arrayfun(@(n)set([AxisHandle(n).DetachPointsHandle.Node{:}],'MarkerFaceColor',ColorOrder(n,:)),1:numel(AxisHandle));

AxisHandle = arrayfun(@(x)copyobj(x.PlotHandle,FigureHandle),AxisHandle,'un',0);
AxisHandle = arrayfun(@(n)subplot(numel(AxisHandle),1,n,AxisHandle{n}),1:numel(AxisHandle),'un',0);
AxisHandle = cat(1,AxisHandle{:});
arrayfun(@(x)close(x.FigureHandle),AxisHandle);

set(AxisHandle,'PlotBoxAspectRatio',[1,4,1],'XDir','reverse','TickDir','out','YGrid','off');
arrayfun(@(x)view(x,-90,90),AxisHandle);
ylabel(AxisHandle(end),'Time (h)');

set(AxisHandle,'FontSize',24);

arrayfun(@(n)text(0.05,0.95,sprintf('%g',n),'units','normalized','parent',AxisHandle(n),...
    'HorizontalAlignment','left','VerticalAlignment','top','clipping','off','FontSize',36),1:numel(AxisHandle));

%% Fig. 4e: 2D trajectory plots

FigureHandle = figure('NumberTitle','off','Name','Fig. 4e: 2D Trajectory Plot');
AxisHandle = axes('parent',FigureHandle,'NextPlot','add');

ColorOrder = [
    198,168,92
    30,165,138
    9,106,200
    ]./255;

colormap(AxisHandle,ColorOrder);

Idx = [25,12,21];

for n1 = 1:numel(Idx)
    for n2 = 1:numel(RegularData(Idx(n1)).TrajectoryData)
        Coord = RegularData(Idx(n1)).TrajectoryData{n2};
        surface('XData',Coord(:,[1,1]),'YData',Coord(:,[2,2]),'ZData',Coord(:,[3,3])./3600,'CData',n1+zeros(size(Coord,1),2),...
            'EdgeColor','interp','FaceColor','none','LineWidth',2,'Parent',AxisHandle)
    end
end
arrayfun(@(d) cellfun(@(x) ...
    plot3(x(1,1),x(1,2),x(1,3)./3600,'k*',...
    'MarkerSize',20,'LineWidth',2.1,'Parent',AxisHandle),...
    d.TrajectoryData(1)), RegularData(Idx));

set(AxisHandle,'CLim',[1,numel(Idx)+1]);

set(AxisHandle,'XColor','k','YColor','k','ZColor','k','Color','none','LineWidth',2);

set(AxisHandle,'XLim',[0,1024]);
set(AxisHandle,'YLim',[0,1024]);
set(AxisHandle,'ZLim',[min(min(cell2mat(get(findobj(AxisHandle,'type','surface'),'ZData')))),max(max(cell2mat(get(findobj(AxisHandle,'type','surface'),'ZData'))))]);
set(AxisHandle,'ZDir','reverse');
set(AxisHandle,'DataAspectRatio',[1,1,diff(zlim(AxisHandle(1)))/diff(xlim(AxisHandle(1)))]);
set(AxisHandle,'Box','on');
set(AxisHandle,'XDir','reverse');

view(AxisHandle,180,90);

arrayfun(@(h)xlabel(h,'X (\mum)'),AxisHandle);
arrayfun(@(h)ylabel(h,'Y (\mum)'),AxisHandle);
arrayfun(@(h)zlabel(h,'Time (h)'),AxisHandle);

%% Fig. 4 - S1a: I_cdGMP vs F_motile (DwspR)

FigureHandle = figure('NumberTitle','off','Name','Fig. DwspR: I_cdGMP vs F_motile');
AxisHandle = axes('parent',FigureHandle);
set(AxisHandle,'NextPlot','add','Color','none','XColor','k','YColor','k','LineWidth',2,'TickLength',0.025+[0,0],'TickDir','out');

Data = [[DwspRData.F_motile];[DwspRData.I_cdGMP]]';

plot(Data(:,1),Data(:,2),'parent',AxisHandle,'LineWidth',2,'MarkerSize',15,'LineStyle','none','Marker','d','MarkerEdgeColor','k','MarkerFaceColor',0.75+[0,0,0]);

[~,D,X,Y] = kde2d(Data,2^8,[0,0],[0.4,1]);
dX = X(1,2)-X(1,1);
dY = Y(2,1)-Y(1,1);

[DS,DSidx] = sort(D(:),'descend');
[~,Didx] = sort(DSidx,'ascend');
CumDS = cumsum(DS.*dX.*dY);
CumDS = CumDS ./ max(CumDS);
CumD = reshape(CumDS(Didx),size(D));

[~,ContourHandle] = contour(AxisHandle,X,Y,CumD,'Fill','off','LineStyle','-','LineWidth',2.1,'Color',0.5+[0,0,0],'parent',AxisHandle);
ContourHandle = [ContourHandle; copyobj(ContourHandle,AxisHandle)];
uistack(ContourHandle,'bottom');
set(ContourHandle(1),'LevelList',0.95,'LineStyle','-');
set(ContourHandle(2),'LevelList',0.5,'LineStyle','--');

[rho,pval] = corr(Data(:,1),Data(:,2),'type','spearman');

text(0.95,0.95,{sprintf('\\rho = %0.3g',rho),sprintf('p-val = %0.2g',pval),''},'units','normalized','parent',AxisHandle,...
    'HorizontalAlignment','right','VerticalAlignment','top','clipping','off','Rotation',0);

set(AxisHandle,'XLim',[0,0.4],'XTick',0:0.1:0.4);
set(AxisHandle,'YLim',[0,1],'YTick',0:.25:1);
set(AxisHandle,'PlotBoxAspectRatio',[1,1,1]);

xlabel(AxisHandle,'F_{motile}');
ylabel(AxisHandle,'I_{c-di-GMP}');

%% Fig. 4 - S1b: I_cdGMP vs TreeAsym (DwspR)

FigureHandle = figure('NumberTitle','off','Name','Fig. DwspR: I_cdGMP vs TreeAsym');
AxisHandle = axes('parent',FigureHandle);
set(AxisHandle,'NextPlot','add','Color','none','XColor','k','YColor','k','LineWidth',2,'TickLength',0.025+[0,0],'TickDir','out');

Data = [[DwspRData.TreeAsym];[DwspRData.I_cdGMP]]';

plot(Data(:,1),Data(:,2),'parent',AxisHandle,'LineWidth',2,'MarkerSize',15,'LineStyle','none','Marker','d','MarkerEdgeColor','k','MarkerFaceColor',0.75+[0,0,0]);

[~,D,X,Y] = kde2d(Data,2^8,[0,0],[1,1]);
dX = X(1,2)-X(1,1);
dY = Y(2,1)-Y(1,1);

[DS,DSidx] = sort(D(:),'descend');
[~,Didx] = sort(DSidx,'ascend');
CumDS = cumsum(DS.*dX.*dY);
CumDS = CumDS ./ max(CumDS);
CumD = reshape(CumDS(Didx),size(D));

[~,ContourHandle] = contour(AxisHandle,X,Y,CumD,'Fill','off','LineStyle','-','LineWidth',2.1,'Color',0.5+[0,0,0],'parent',AxisHandle);
ContourHandle = [ContourHandle; copyobj(ContourHandle,AxisHandle)];
uistack(ContourHandle,'bottom');
set(ContourHandle(1),'LevelList',0.95,'LineStyle','-');
set(ContourHandle(2),'LevelList',0.5,'LineStyle','--');

[rho,pval] = corr(Data(:,1),Data(:,2),'type','spearman');

text(0.95,0.95,{sprintf('\\rho = %0.3g',rho),sprintf('p-val = %0.2g',pval),''},'units','normalized','parent',AxisHandle,...
    'HorizontalAlignment','right','VerticalAlignment','top','clipping','off','Rotation',0);

set(AxisHandle,'XLim',[0,1],'XTick',0:.25:1);
set(AxisHandle,'YLim',[0,1],'YTick',0:.25:1);
set(AxisHandle,'PlotBoxAspectRatio',[1,1,1]);

xlabel(AxisHandle,'Tree Asymmetry \lambda');
ylabel(AxisHandle,'I_{c-di-GMP}');

%% Fig. X: I_cdGMP_single vs F_motile_single (WT vs DwspR)

FigureHandle = figure('NumberTitle','off','Name','Fig. X: I_cdGMP_single vs F_motile_single WT vs DwspR');
AxisHandle = axes('parent',FigureHandle);
set(AxisHandle,'NextPlot','add','Color','none','XColor','k','YColor','k','LineWidth',2,'TickLength',0.025+[0,0],'TickDir','out','PlotBoxAspectRatio',[1,1,1]);
AxisHandle = [subplot(1,2,1,AxisHandle),subplot(1,2,2,copyobj(AxisHandle,FigureHandle))];

Data = [cat(1,RegularData.F_motile_single),cat(1,RegularData.I_cdGMP_single)];
Data(any(~isfinite(Data),2),:) = [];

plot(Data(:,1),Data(:,2),'parent',AxisHandle(1),'LineWidth',2,'MarkerSize',15,'LineStyle','none','Marker','o','MarkerEdgeColor','k','MarkerFaceColor',0.75+[0,0,0]);
[rho,pval] = corr(Data(:,1),Data(:,2),'type','spearman','rows','complete');

text(0.95,0.95,{sprintf('\\rho = %0.3g',rho),sprintf('p-val = %0.2g',pval),''},'units','normalized','parent',AxisHandle(1),...
    'HorizontalAlignment','right','VerticalAlignment','top','clipping','off','Rotation',0);

xlabel(AxisHandle(1),'F_{motile} single cells');
ylabel(AxisHandle(1),'I_{c-di-GMP} single cells');
title(AxisHandle(1),'WT','interpreter','latex');

Data = [cat(1,DwspRData.F_motile_single),cat(1,DwspRData.I_cdGMP_single)];
Data(any(~isfinite(Data),2),:) = [];

plot(Data(:,1),Data(:,2),'parent',AxisHandle(2),'LineWidth',2,'MarkerSize',15,'LineStyle','none','Marker','o','MarkerEdgeColor','k','MarkerFaceColor',0.75+[0,0,0]);
[rho,pval] = corr(Data(:,1),Data(:,2),'type','spearman','rows','complete');

text(0.95,0.95,{sprintf('\\rho = %0.3g',rho),sprintf('p-val = %0.2g',pval),''},'units','normalized','parent',AxisHandle(2),...
    'HorizontalAlignment','right','VerticalAlignment','top','clipping','off','Rotation',0);

xlabel(AxisHandle(2),'F_{motile} single cells');
ylabel(AxisHandle(2),'I_{c-di-GMP} single cells');
title(AxisHandle(2),'$\Delta wspR$','interpreter','latex');

set(AxisHandle,'XLim',[0,1],'XTick',0:0.25:1);
set(AxisHandle,'YLim',[0,1],'YTick',0:0.25:1);

