function [optionalInputs,presentInputs,missingInputs] = checkOptionalInputs(optionalInputs, defaultInputs, validInputs)

% validate optional input parameters against the default parameters (keep only the correct parameters)
defaultFieldNames = fieldnames(defaultInputs);
inputFieldNames = fieldnames(optionalInputs);
if ~(numel(inputFieldNames) == numel(defaultFieldNames) && all(strcmp(inputFieldNames, defaultFieldNames)))
    hasRequiredFields = false(size(defaultFieldNames));
    for n = 1:numel(inputFieldNames)
        if sum(strcmp(inputFieldNames{n},defaultFieldNames)) == 1
            currentFieldName = inputFieldNames{n};
        else
            try
                currentFieldName = validatestring(inputFieldNames{n},defaultFieldNames);
            catch
                optionalInputs = rmfield(optionalInputs, inputFieldNames{n});
                continue
            end
            optionalInputs.(currentFieldName) = optionalInputs.(inputFieldNames{n});
            optionalInputs = rmfield(optionalInputs, inputFieldNames{n});
        end
        hasRequiredFields = hasRequiredFields | strcmp(currentFieldName,defaultFieldNames);
    end
    for n = 1:numel(hasRequiredFields)
        if ~hasRequiredFields(n)
            optionalInputs.(defaultFieldNames{n}) = defaultInputs.(defaultFieldNames{n});
        end
    end
    optionalInputs = orderfields(optionalInputs, defaultFieldNames);
else
    hasRequiredFields = true(size(defaultFieldNames));    
end

presentInputs = defaultFieldNames(hasRequiredFields);
missingInputs = defaultFieldNames(~hasRequiredFields);

% validate optional input values
inputFieldNames = fieldnames(optionalInputs);
for n = 1:numel(inputFieldNames)
    currentFieldName = inputFieldNames{n};
    if ~isempty(defaultInputs.(currentFieldName))
        validateInputName = sprintf('optional input ''%s''', currentFieldName);
        switch class(validInputs.(currentFieldName){1})
            case 'cell'
                validateattributes(optionalInputs.(currentFieldName), validInputs.(currentFieldName){:},...
                    mfilename, validateInputName)
            case 'char'
                switch validInputs.(currentFieldName){1}(1)
                    case '.'
                        optionalInputs.(currentFieldName) = lower(optionalInputs.(currentFieldName));
                        if isempty(strfind(optionalInputs.(currentFieldName),'.'))
                            optionalInputs.(currentFieldName) = ['.' optionalInputs.(currentFieldName)];
                        end
                end
                optionalInputs.(currentFieldName) = validatestring(optionalInputs.(currentFieldName),...
                    validInputs.(currentFieldName), mfilename, validateInputName);
        end
        
    end
end

end