
phenotypes=c("Ctrl", "20minsSalt", "60minsSalt" , "Recovery")
# remember to change n for for loop

#Change input directories
dirs=c("C:/Users/savani/Box Sync/Images/Salt stress/15-12-11 Salt stress OxtGFP 8dpf/Raw data/Control",
       "C:/Users/savani/Box Sync/Images/Salt stress/15-12-11 Salt stress OxtGFP 8dpf/Raw data/20mins salt",
       "C:/Users/savani/Box Sync/Images/Salt stress/15-12-11 Salt stress OxtGFP 8dpf/Raw data/60mins salt",
       "C:/Users/savani/Box Sync/Images/Salt stress/15-12-11 Salt stress OxtGFP 8dpf/Raw data/recovery")

######

HB.blobs=as.data.frame(matrix(NA,ncol=11))
names(HB.blobs)=c("Pheno","BlobsID", "Item.Name","Volume","CentX","CentY","CentZ","CompartmentID","NoofOxt", "OxtPixels", "GFPPixels")
HB.with.oxt=as.data.frame(matrix(NA,ncol=11))
names(HB.with.oxt)=c("Pheno","BlobsID","Item.Name","Volume","CentX","CentY","CentZ","CompartmentID","NoofOxt", "OxtPixels", "GFPPixels")
HB.without.oxt=as.data.frame(matrix(NA,ncol=11))
names(HB.without.oxt)=c("Pheno","BlobsID","Item.Name","Volume","CentX","CentY","CentZ","CompartmentID","NoofOxt", "OxtPixels", "GFPPixels")


GP.oxt=as.data.frame(matrix(NA,ncol=11))
names(GP.oxt)=c("Pheno","BlobsID","Item.Name","Volume","CentX","CentY","CentZ","CompartmentID","NoofOxt", "OxtPixels", "GFPPixels")
oxt.HB=as.data.frame(matrix(NA,ncol=11))
names(oxt.HB)=c("Pheno","BlobsID","Item.Name","Volume","CentX","CentY","CentZ","CompartmentID","NoofOxt", "OxtPixels", "GFPPixels")
oxt.not.HB=as.data.frame(matrix(NA,ncol=11))
names(oxt.not.HB)=c("Pheno","BlobsID","Item.Name","Volume","CentX","CentY","CentZ","CompartmentID","NoofOxt", "OxtPixels", "GFPPixels")


#########################
#Change X to number of groups 
#for (i in 1: X)
########################

for (i in 1:4) {
  setwd(dirs[i])
  files=list.files(path=dirs[i])
  
  for (j in 1:length(files)) {
    
    tempfile=read.delim(files[j])
    
    HB.blobs.temp=tempfile[tempfile$Population=="GFP Blobs of size 0.2 to 25 um3",c(1,2,9,20:22,42,43, 17,12)]
    Pheno=rep(phenotypes[i],dim(HB.blobs.temp)[1])
    HB.blobs.temp=cbind(Pheno,HB.blobs.temp)
    names(HB.blobs.temp)=names(HB.blobs)
    HB.blobs=rbind(HB.blobs,HB.blobs.temp)
    
    
    
    HB.with.oxt.temp=tempfile[tempfile$Population=="GFP with oxytocin",c(1,2,9,20:22,42,43, 17,12)]
    Pheno=rep(phenotypes[i],dim(HB.with.oxt.temp)[1])
    HB.with.oxt.temp=cbind(Pheno,HB.with.oxt.temp)
    names(HB.with.oxt.temp)=names(HB.with.oxt)
    HB.with.oxt=rbind(HB.with.oxt,HB.with.oxt.temp)
    
    
    
    
    HB.without.oxt.temp=tempfile[tempfile$Population=="GFP without oxytocin",c(1,2,9,20:22,42,43, 17,12)]
    Pheno=rep(phenotypes[i],dim(HB.without.oxt.temp)[1])
    HB.without.oxt.temp=cbind(Pheno,HB.without.oxt.temp)
    names(HB.without.oxt.temp)=names(HB.without.oxt)
    HB.without.oxt=rbind(HB.without.oxt,HB.without.oxt.temp)
    
    
    GP.oxt.temp=tempfile[tempfile$Population=="GP-Oxt of size 0.2 to 25",c(1,2,9,20:22,42,43 , 17,12)]
    Pheno=rep(phenotypes[i],dim(GP.oxt.temp)[1])
    GP.oxt.temp=cbind(Pheno,GP.oxt.temp)
    names(GP.oxt.temp)=names(GP.oxt)
    GP.oxt=rbind(GP.oxt,GP.oxt.temp)
    
    
    oxt.HB.temp=tempfile[tempfile$Population=="Oxt in HB",c(1,2,9,20:22,42,43 , 17,12)]
    Pheno=rep(phenotypes[i],dim(oxt.HB.temp)[1])
    oxt.HB.temp=cbind(Pheno,oxt.HB.temp)
    names(oxt.HB.temp)=names(oxt.HB)
    oxt.HB=rbind(oxt.HB,oxt.HB.temp)
    
    
    
    
    oxt.not.HB.temp=tempfile[tempfile$Population=="Oxt not in HB",c(1,2,9,20:22,42,43 , 17,12)]
    Pheno=rep(phenotypes[i],dim(oxt.not.HB.temp)[1])
    oxt.not.HB.temp=cbind(Pheno,oxt.not.HB.temp)
    names(oxt.not.HB.temp)=names(oxt.not.HB)
    oxt.not.HB=rbind(oxt.not.HB,oxt.not.HB.temp)
    
    
    
  }
}




HB.blobs=HB.blobs[is.na(HB.blobs$Pheno)==F,]
HB.with.oxt=HB.with.oxt[is.na(HB.with.oxt$Pheno)==F,]
HB.without.oxt=HB.without.oxt[is.na(HB.without.oxt$Pheno)==F,]

GP.oxt=GP.oxt[is.na(GP.oxt$Pheno)==F,]
oxt.HB=oxt.HB[is.na(oxt.HB$Pheno)==F,]
oxt.not.HB=oxt.not.HB[is.na(oxt.not.HB$Pheno)==F,]



##########
setwd("C:/Users/savani/Box Sync/Images/Salt stress/15-12-11 Salt stress OxtGFP 8dpf/Extracted data")


write.csv(HB.blobs,file="GFP blobs.csv")
write.csv(HB.with.oxt,file="GFP with oxytocin.csv")
write.csv(HB.without.oxt,file="GFP without oxt.csv")

write.csv(GP.oxt,file="GP oxt.csv")
write.csv(oxt.HB,file="oxt HB.csv")
write.csv(oxt.not.HB,file="oxt not HB.csv")




