
setwd("C:/Users/savani/Box Sync/Images/Salt stress/15-12-11 Salt stress OxtGFP 8dpf/Extracted data")

### Axonal swelling = Synapses = Herring bodies  

#Total Axonal swelling counts
GFPblobstotal.dat=read.csv("GFP blobs Transformed.csv")
GFPblobstotal.dat$Pheno <- factor(GFPblobstotal.dat$Pheno, levels = c("Ctrl", "20minsSalt", "60minsSalt" , "Recovery"))
GFPblobstotal.dat$Pheno=as.factor(GFPblobstotal.dat$Pheno)

#Select only <25
GFPblobstotal.dat <- subset(GFPblobstotal.dat, Volume <25)


# Extraction of number of total Herring bodies
GFPblobstotal.counts=table(GFPblobstotal.dat$Item.Name,GFPblobstotal.dat$Pheno)
GFPblobstotal.counts=as.data.frame(GFPblobstotal.counts) #Rearrange data
GFPblobstotal.counts=GFPblobstotal.counts[GFPblobstotal.counts$Freq>0,] #Remove values with zeroes created by TABLE command


#Counts analysis
boxplot(Freq ~ Var2 , data = GFPblobstotal.counts , ylab = "# Axonal swellings")



kruskal.test(Freq ~ Var2 , data = GFPblobstotal.counts)
totalGFPHB.counts.anova=aov(Freq~Var2,data=GFPblobstotal.counts)   
summary(totalGFPHB.counts.anova)
totalGFPHB.counts.anova.tukey=TukeyHSD(totalGFPHB.counts.anova)
totalGFPHB.counts.anova.tukey


# Save GFP HB counts data
names(GFPblobstotal.counts)=c("Fish ID","Age","No of GFP HB")
write.csv(GFPblobstotal.counts,file="Results_Counts_Total No of GFP HB.csv",row.names=F)


################

#Total Oxt blobs
Oxtblobstotal.dat=read.csv("oxt total Transformed.csv")
Oxtblobstotal.dat$Pheno <- factor(Oxtblobstotal.dat$Pheno, levels = c("Ctrl", "20minsSalt", "60minsSalt" , "Recovery"))
Oxtblobstotal.dat$Pheno=as.factor(Oxtblobstotal.dat$Pheno)

#Select only <25
Oxtblobstotal.dat <- subset(Oxtblobstotal.dat, Volume <25)

# Extraction of number of total Herring bodies
Oxtblobstotal.counts=table(Oxtblobstotal.dat$Item.Name,Oxtblobstotal.dat$Pheno)
Oxtblobstotal.counts=as.data.frame(Oxtblobstotal.counts) #Rearrange data
Oxtblobstotal.counts=Oxtblobstotal.counts[Oxtblobstotal.counts$Freq>0,] #Remove values with zeroes created by TABLE command


#Counts analysis
boxplot(Freq ~ Var2 , data = Oxtblobstotal.counts , ylab = "# Oxt blobs")



kruskal.test(Freq ~ Var2 , data = Oxtblobstotal.counts)
Oxtblobstotal.counts.anova=aov(Freq~Var2,data=Oxtblobstotal.counts)   
summary(Oxtblobstotal.counts.anova)
Oxtblobstotal.counts.anova.tukey=TukeyHSD(Oxtblobstotal.counts.anova)
Oxtblobstotal.counts.anova.tukey


# Save Oxt blobs counts data
names(Oxtblobstotal.counts)=c("Fish ID","Age","No of Oxt blobs")
write.csv(Oxtblobstotal.counts,file="Results_Counts_Total No of Oxt blobs.csv",row.names=F)


###############




#Read HB with Oxt data

GFPblobsdat=read.csv("GFP blobs with oxt Transformed.csv")
GFPblobsdat$Pheno <- factor(GFPblobsdat$Pheno, levels = c("Ctrl", "20minsSalt", "60minsSalt" , "Recovery" ))
GFPblobsdat$Pheno=as.factor(GFPblobsdat$Pheno)
GFPblobsdat <- subset(GFPblobsdat, Volume <25)




names(GFPblobsdat)
summary(GFPblobsdat)


# Extraction of number of Herring bodies
GFPblobscounts=table(GFPblobsdat$Item.Name,GFPblobsdat$Pheno)
GFPblobscounts=as.data.frame(GFPblobscounts) #Rearrange data
GFPblobscounts=GFPblobscounts[GFPblobscounts$Freq>0,] #Remove values with zeroes created by TABLE command


#Counts analysis
boxplot(Freq ~ Var2 , data = GFPblobscounts , ylab = "# Oxt+ Axonal swellings" )




kruskal.test(GFPblobscounts$Freq ~ GFPblobscounts$Var2 , data = GFPblobscounts)
counts.anova=aov(Freq~Var2,data=GFPblobscounts)   
summary(counts.anova)
counts.anova.tukey=TukeyHSD(counts.anova)
counts.anova.tukey


# Save GFP HB counts data
names(GFPblobscounts)=c("Fish ID","Age","No of GFP HB with Oxt")
write.csv(GFPblobscounts,file="Results_Counts_No of GFP HB with Oxt.csv",row.names=F)




############Total oxt in HB counts

oxtinHB.dat=read.csv("oxt in HB Transformed.csv")
oxtinHB.dat$Pheno <- factor(oxtinHB.dat$Pheno, levels = c("Ctrl", "20minsSalt", "60minsSalt" , "Recovery"))
oxtinHB.dat$Pheno=as.factor(oxtinHB.dat$Pheno)

#Select only <25
oxtinHB.dat <- subset(oxtinHB.dat, Volume <25)



oxtinHB.counts=table(oxtinHB.dat$Item.Name,oxtinHB.dat$Pheno)
oxtinHB.counts=as.data.frame(oxtinHB.counts) #Rearrange data
oxtinHB.counts=oxtinHB.counts[oxtinHB.counts$Freq>0,] #Remove values with zeroes created by TABLE command


#Counts analysis
boxplot(Freq ~ Var2 , data = oxtinHB.counts , ylab = "# AS+ Oxt" )




kruskal.test(oxtinHB.counts$Freq ~ oxtinHB.counts$Var2 , data = oxtinHB.counts)
counts.anova=aov(Freq~Var2,data=oxtinHB.counts)   
summary(counts.anova)
counts.anova.tukey=TukeyHSD(counts.anova)
counts.anova.tukey


# Save GFP HB without Oxt counts data
names(oxtinHB.counts)=c("Fish ID","Age","No of HBpositive Oxt")
write.csv(oxtinHB.counts,file="Results_Counts_No of Oxt blobs in HB.csv",row.names=F)





##############


#Volume analysis



#Volume analysis for total HB





#Calc individual means & plot
logGFPHB_total_means <- aggregate(logVolume ~ Pheno + Item.Name , data=GFPblobstotal.dat, mean)
boxplot(logVolume ~ Pheno , data = logGFPHB_total_means, ylab = "Mean Total HB volume (Scale: log10)")

kruskal.test(logVolume ~ Pheno , data = logGFPHB_total_means)
logGFPHB_total_means.anova <- aov(logVolume ~ Pheno , data = logGFPHB_total_means)
summary(logGFPHB_total_means.anova )

logGFPHB_total_means.anova.tukey=TukeyHSD(logGFPHB_total_means.anova)
logGFPHB_total_means.anova.tukey


logGFPHB_total_means$backTransformedVolume <- 10^(logGFPHB_total_means$logVolume)


write.csv(logGFPHB_total_means,file="Results_MeanVolumes_HB_total.csv",row.names=F)



###############


#HB with Oxt

#Calc individual means & plot
logGFPHBmeans <- aggregate(logVolume ~ Pheno + Item.Name , data=GFPblobsdat, mean)
boxplot(logVolume ~ Pheno , data = logGFPHBmeans, ylab = "Mean Oxt+ AS volume (Scale: log10)")

kruskal.test(logVolume ~ Pheno , data = logGFPHBmeans)
logGFPHBmeans.anova <- aov(logVolume ~ Pheno , data = logGFPHBmeans)
summary(logGFPHBmeans.anova )

logGFPHBmeans.anova.tukey=TukeyHSD(logGFPHBmeans.anova)
logGFPHBmeans.anova.tukey


logGFPHBmeans$backTransformedVolume <- 10^(logGFPHBmeans$logVolume)


write.csv(logGFPHBmeans,file="Results_MeanVolumes_HB_with_Oxt.csv",row.names=F)




####################


#Oxt Volume total  analysis




#Calc individual means & plot
log_total_oxt_volmeans <- aggregate(logVolume ~ Pheno + Item.Name , data=Oxtblobstotal.dat, mean)
boxplot(logVolume ~ Pheno , data = log_total_oxt_volmeans, ylab = "Mean total Oxt blob volume (Scale: log10)")

kruskal.test(logVolume ~ Pheno , data = log_total_oxt_volmeans)
log_total_oxt_volmeans.anova <- aov(logVolume ~ Pheno , data = log_total_oxt_volmeans)
summary(log_total_oxt_volmeans.anova )

log_total_oxt_volmeans.anova.tukey=TukeyHSD(log_total_oxt_volmeans.anova)
log_total_oxt_volmeans.anova.tukey




log_total_oxt_volmeans$backTransformedVolume <- 10^(log_total_oxt_volmeans$logVolume)


write.csv(log_total_oxt_volmeans,file="Results_MeanVolumes_Oxt_total.csv",row.names=F)







###################



#Oxt in HB Volume analysis


#### oxt in HB volume analysis

#Calc individual means & plot
logOxtVolmeans <- aggregate(logVolume ~ Pheno + Item.Name , data=oxtinHB.dat, mean)
boxplot(logVolume ~ Pheno , data = logOxtVolmeans, ylab = "Mean AS+ Oxt blob volume (Scale: log10)")

kruskal.test(logVolume ~ Pheno , data = logOxtVolmeans)
logOxtVolmeans.anova <- aov(logVolume ~ Pheno , data = logOxtVolmeans)
summary(logOxtVolmeans.anova )

logOxtVolmeans.anova.tukey=TukeyHSD(logOxtVolmeans.anova)
logOxtVolmeans.anova.tukey




logOxtVolmeans$backTransformedVolume <- 10^(logOxtVolmeans$logVolume)


write.csv(logOxtVolmeans,file="Results_MeanVolumes_Oxt_in_HB.csv",row.names=F)


