

setwd("C:/Savani/Mining/gil lab/Box Sync/Images/Astray/astray_GFP vs cdc42 DNA")

#library(lme4)
library(arm)
library(dplyr)
library(ggplot2)

blobdat <- rio::import("uasgfp vs uascdc42.xlsx")
blobdat$Pheno <-factor(blobdat$Pheno, levels=c('wt_uasgfp', 'homo_uasgfp','wt_uascdc42','homo_uascdc42'))


blobdat$log.gfpmeanint <- log(blobdat$MeanGFPint)
blobdat$log.oxtmeanint <- log(blobdat$MeanOXTint)

############# Normalize data for plotting
blobdat <- blobdat %>%
  
  group_by(Item.Name) %>%
  
  mutate(log.gfp.scaled=as.numeric(scale(log.gfpmeanint)), log.oxt.scaled=as.numeric(scale(log.oxtmeanint)))


########plots

g <- ggplot(data=blobdat, aes(x=log.gfp.scaled, y=log.oxt.scaled)) +
  geom_point() +
  geom_smooth(aes(color="customized"), method='lm', se=FALSE)+
  scale_color_manual(name="overexpressions",                    values=c(customized="#8B008B")) +
  facet_wrap( ~ Pheno, nrow=1) + labs(title="Compare overexpression expt")   # Shared scales 

g + theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour = "black"))




######## Linear models per pheno

m.wtgfp <- lm(log.oxtmeanint ~ Item.Name + log.gfpmeanint, 
              data=filter(blobdat, Pheno=="wt_uasgfp"))
summary(m.wtgfp)

m.homogfp <- lm(log.oxtmeanint ~ Item.Name + log.gfpmeanint, 
                data=filter(blobdat, Pheno=="homo_uasgfp"))
summary(m.homogfp)

###################

m.wtcdc42 <- lm(log.oxtmeanint ~ Item.Name + log.gfpmeanint, 
                data=filter(blobdat, Pheno=="wt_uascdc42"))
summary(m.wtcdc42)

m.homocdc42 <- lm(log.oxtmeanint ~ Item.Name + log.gfpmeanint, 
                  data=filter(blobdat, Pheno=="homo_uascdc42"))
summary(m.homocdc42)


