function [Ef,Mask,Seq]=AccPhotobleaching(ImageName,ROIS,bleachframe)
%%Loads .tiff images and creates a mask from ROIs. Then calculate the Fret
%%efficiency for each region according to Ef=(IntPost-IntPre)/IntPost
close all;
ImageNames=sbe(ImageName,1);
for k=1:length(ImageNames)
    file=strcat(ImageNames(k).directory,ImageNames(k).name);
    Im=imread(file);
    Im_Filt=imgaussfilt(Im,0.75);
    Seq(:,:,k)=Im_Filt;
end
imagesc(Im_Filt);
[ImSize]=size(Im_Filt);
Mask=MaskfromROI(ImSize,ROIS);
[LabelMask,N]=bwlabel(Mask);
figure;imagesc(LabelMask);
PostImage=Seq(:,:,bleachframe);
PreImage=Seq(:,:,bleachframe-1);
Ef=[];

for i=1:N
    ind=find(LabelMask==i);
    IntPre=mean(PreImage(ind));
    IntPost=mean(PostImage(ind));
    FretEf=((IntPost-IntPre)/IntPost)*100;
    Ef=[Ef,FretEf];
end
Ef=Ef';