function [] = unpack_struct(ss, ws)

%unpack_struct Creates and/or assigns variables in the base workspace
%
%   [] = unpack_struct(ss, [ws])
%
% This functions creates or assigns variables as specified by the
% field names and values in structure ss. 
%
% For example, if ss consists of 
%
%   crap1: 123
%   crap2: 'Hello'
%   more_crap: 3.1416
%
% then the call unpack_struct(ss) assigns the values 123, 'Hello', and
% 2.1416 to the three variables crap1, crap2, and more_crap, whether
% they already exist in the workspace or not.
%
% The workspace can be either 'base' (the default) or 'caller'.

% Copyright (c) 2018 Emilio Salinas

if ~isstruct(ss)
    error('Input ss must be a structure')
end

if length(ss) > 1
    error('Input ss must be a scalar struct')
end

if nargin < 2
    ws = 'base';
end

names = fieldnames(ss);
vals = struct2cell(ss);

nn = length(names);

for j=1:nn
    assignin(ws, names{j}, vals{j});
end



