#ifndef CPM_Edge_hpp
#define CPM_Edge_hpp

#include <list>

class Tile;
class Cell;

class Edge{

public:

    /*!
     *  Default constructor is not allowed.
     */
    Edge() = delete;

    /*!
     *  Construct edge element from given data
     *  @param tile             Tile owning the Edge
     *  @param relative_index   Relative index of the Edge relative to its Tile
     */
    Edge(Tile* tile, size_t relative_index)
    : m_Index(relative_index)
    , m_Cell(nullptr)
    , m_IndexCell(0)
    , m_Length(0.)
    , m_Tile(tile)
    , m_Comp(nullptr)
    {};

    /*!
     *  Get index of edge relative to its Tile
     */
    const size_t& Index() const {
        return m_Index;
    };

    /*!
     * Get pointer to Cell currently owning this Edge
     */
    Cell* GetCell() const{
        return m_Cell;
    };

    /*!
     * Get pointer to inner Tile
     */
    Tile* GetTile() const {
        return m_Tile;
    };

    /*!
     * Get pointer to complementary (mirror) Edge
     */
    Edge* GetComp() const {
        return m_Comp;
    }

    /*!
     * Get length of this edge
     */
    const double_t Length() const {
        return m_Length;
    };

private:

    const size_t m_Index; ///< Index of edge relative to its Tile

    Cell* m_Cell; ///< Pointer to Cell currently owning this Edge
    size_t m_IndexCell; ///< Index of Edge within the cell membrane

    double_t m_Length; ///< Length of this Edge

    Tile* m_Tile; ///< Pointer to inner Tile
    Edge* m_Comp; ///< Pointer to complementary (mirror) Edge

    friend class Grid;
    friend class Cell;

};

#endif /* CPM_Edge_hpp */
