#ifndef IO_Parameters_hpp
#define IO_Parameters_hpp

#include <iostream>
#include <cmath>
#include <stdio.h>
#include <string>

class Parameters {

public:

    /*!
     *  Default constructor is not allowed.
     */
    Parameters() = delete;

    /*!
     *  Tries to read configuration either from .json file or from the command line. If this fails, it rolls back to the predefined values. At the end of the function, it saves the updated parameters in the .json file.
     */
    Parameters(int argc, char* argv[]);

    /*!
     *  Copy constructor is not allowed.
     */
    Parameters(Parameters& base) = delete;

    ///////////////////////////////////////////////
    ///// Getter Functions
    ////////////////////////

    /*!
     *  Get number of cells.
     */
    const size_t& N_Cells() const {
        return m_N_Cells;
    };

    /*!
     *  Get number of columns.
     */
    const size_t& N_Columns() const {
        return m_N_Columns;
    };

    /*!
     *  Get number of rows.
     */
    const size_t& N_Rows() const {
        return m_N_Rows;
    };

    /*!
     *  Get measurement interval.
     */
    const uint_fast32_t& I_Measure() const {
        return m_I_Measure;
    };

    /*!
     *  Get flag indicating whether extended measurement of cell shall be performed.
     */
    const bool& MeasureExtended() const {
        return m_CellMeasureExtended;
    };

    /*!
     *  Get flag indicating whether Maps are to be measured.
     */
    const bool& MeasureMaps() const {
        return m_CellMeasureMaps;
    };

    /*!
     *  Get flag indicating whether Monolayers are to be measured.
     */
    const bool& MeasureMono() const {
        return m_MeasureMono;
    };

private:

    size_t m_N_Cells; ///< Number of cells
    size_t m_N_Columns; ///< Number of columns
    size_t m_N_Rows; ///< Number of rows
    uint_fast32_t m_I_Measure; ///< Measurement interval

    bool m_CellMeasureExtended; ///< Perform extended measurement of the cell?
    bool m_CellMeasureMaps; ///< Flag indicating whether Maps are to be measured
    bool m_MeasureMono; ///< Flag indicating whether Monolayer measurements are to be done

};

#endif /* IO_Parameters_hpp */
