#include "IO_Analysis.hpp"

static const std::string DGroupName_Monolayer = "Monolayer";
static const std::string DSetName_Monolayer_FrontLeft = "Front_Left";
static const std::string DSetName_Monolayer_FrontRight = "Front_Right";

Analysis::Analysis()
{


    H5::H5File H5Import ("Data.h5", H5F_ACC_RDONLY);
    H5::Group H5Group = H5Import.openGroup(DGroupName_Monolayer);

    // LEFT FRONT
    H5::DataSet H5Dataset = H5Group.openDataSet(DSetName_Monolayer_FrontLeft);
    H5::CompType H5Type = H5Dataset.getCompType();
    H5::DataSpace H5Dataspace = H5Dataset.getSpace();
    std::array<hsize_t,2> Dims;
    H5Dataspace.getSimpleExtentDims(Dims.data());

    std::vector<Data0D> m_DataResult (Dims.at(0), {0.,0.});

    std::vector<DataFront> DataImport (Dims.at(0) * Dims.at(1));
    H5Dataset.read(DataImport.data(), H5Type);

    for(size_t t = 0; t < Dims.at(0); ++t) {
        for(size_t i = 0; i < Dims.at(1); ++i) {
            auto elem = DataImport[t*Dims.at(1) + i];
            double_t x = std::abs(elem.X);
            double_t y = std::abs(elem.Y);
            if(x > 1. && x < 701. && y > 1. && y <350*sqrt(3)/2 + 1.) {
                m_DataResult[t].Mean += x;
                m_DataResult[t].Variance += x * x;
                ++m_DataResult[t].Count;
            }
        }
    }

    H5Dataspace.close();
    H5Type.close();
    H5Dataset.close();

    // RIGHT FRONT

    {
        H5::DataSet H5Dataset = H5Group.openDataSet(DSetName_Monolayer_FrontRight);
        H5::CompType H5Type = H5Dataset.getCompType();
        H5::DataSpace H5Dataspace = H5Dataset.getSpace();
        std::array<hsize_t,2> Dims;
        H5Dataspace.getSimpleExtentDims(Dims.data());

        std::vector<DataFront> DataImport (Dims.at(0) * Dims.at(1));
        H5Dataset.read(DataImport.data(), H5Type);

        for(size_t t = 0; t < Dims.at(0); ++t) {
            for(size_t i = 0; i < Dims.at(1); ++i) {
                auto elem = DataImport[t*Dims.at(1) + i];
                double_t x = std::abs(elem.X);
                double_t y = std::abs(elem.Y);
                if(x > 1. && x < 701. && y > 1. && y <350*sqrt(3)/2 + 1.) {
                    m_DataResult[t].Mean += x;
                    m_DataResult[t].Variance += x * x;
                    ++m_DataResult[t].Count;
                }
            }
        }

        H5Dataspace.close();
        H5Type.close();
        H5Dataset.close();
    }

    for(auto& elem : m_DataResult) {
        elem.Mean /= elem.Count;
        elem.Variance /= elem.Count;
        elem.Variance -= elem.Mean * elem.Mean;
    }

    {
        H5::H5File file = H5::H5File("Analysis.h5", H5F_ACC_TRUNC);
        H5::CompType Type0D (sizeof(Data0D));
        Type0D.insertMember("Mean", HOFFSET(Data0D, Mean), H5::PredType::NATIVE_DOUBLE);
        Type0D.insertMember("Variance", HOFFSET(Data0D, Variance), H5::PredType::NATIVE_DOUBLE);
        Type0D.insertMember("Count", HOFFSET(Data0D, Count), H5::PredType::NATIVE_UINT_FAST32);

        hsize_t dims[1] = {m_DataResult.size()};
        H5::DataSpace dataspace(1, dims);
        H5::DataSet dataset = file.createDataSet("FrontPosition", Type0D, dataspace);
        dataset.write(m_DataResult.data(), Type0D);
        dataset.close();
        dataspace.close();
        file.close();
    }
}
