#ifndef IO_Analysis_hpp
#define IO_Analysis_hpp

#include <stdio.h>
#include <cmath>
#include <array>
#include <vector>
#include <algorithm>

#include "IO_ParametersReduced.hpp"
#include "Point.hpp"

#include <hdf5.h>
#include <H5Cpp.h>

static const size_t AveragingTime = 1;
static const size_t MeasuringTime = 1;
//static const size_t MaximalTime = 2000;

class Analysis {

public:

    /*!
     *  Simple export struct containing the front positions (X, Y).
     */
    struct DataFront {
        double_t X;
        double_t Y;
    };

    /*!
     *  Simple export struct for averaged data.
     */
    struct Data0D {
        double_t Mean;
        double_t Variance;
        uint_fast32_t Count;
    };

    Analysis();

private:

};

#endif /* IO_Analysis_hpp */
