function A = Kimrose(filename,col, numBin, r_max)

data = xlsread(filename, 1);
An = data(:,col);
fA = An*pi/180;
fA(isnan(fA(:,1)),:) = [];
figure;
%set the maximum radius with fake plot
theta  = linspace(0,2*pi,100);                         
h_fake = polar(theta,r_max*ones(size(theta)));
set(h_fake, 'Visible', 'Off');
hold on;

[tout,rout] = rose(fA,numBin);
relativefreq = rout/length(fA);
A = polar(tout,relativefreq);
hold off;
end

