function kuiperTest
%% Import the data (selecting two files, one at a time)
[file1,path1] = uigetfile('*.xlsx');
[~, ~, raw] = xlsread(fullfile(path1,file1),1);
raw = raw(:,13);
raw(cellfun(@(x) ~isempty(x) && isnumeric(x) && isnan(x),raw)) = {''};
% Replace non-numeric cells with NaN
R = cellfun(@(x) ~isnumeric(x) && ~islogical(x),raw); % Find non-numeric cells
raw(R) = {NaN}; % Replace non-numeric cells

% Create output variable
sample1_raw = reshape([raw{:}],size(raw));
sample1_raw = sample1_raw(not(isnan(sample1_raw)));
% Clear temporary variables
clearvars raw R;
%
[file2,path2] = uigetfile('*.xlsx');
[~, ~, raw] = xlsread(fullfile(path2,file2),1);
raw = raw(:,13);
raw(cellfun(@(x) ~isempty(x) && isnumeric(x) && isnan(x),raw)) = {''};
% Replace non-numeric cells with NaN
R = cellfun(@(x) ~isnumeric(x) && ~islogical(x),raw); % Find non-numeric cells
raw(R) = {NaN}; % Replace non-numeric cells

% Create output variable
sample2_raw = reshape([raw{:}],size(raw));
sample2_raw = sample2_raw(not(isnan(sample2_raw)));

% Clear temporary variables
clearvars raw R;

%%
% wrap around a circle
% sample1 = mod(([sample1_raw+0.1; 180-sample1_raw-0.1; 180+sample1_raw+0.1;-sample1_raw-0.1]./180)*2*pi,2*pi);
% sample2 = mod(([sample2_raw+0.1; -sample2_raw-0.1;180+sample2_raw+0.1; 180-sample2_raw-0.1]./180)*2*pi,2*pi);
% 
% [pVal,testStat,critValue] = circ_kuipertest(sample1, sample2,72,1,4);
% %%
% [pVal] = circ_wwtest(sample1, sample2)

%%

sample1 = sample1_raw;
sample1(sample1==90) = 90-0.0000001;
sample1(sample1==0) = 0.0000001;


sample2 = sample2_raw;
sample2(sample2==90) = 90-0.0000001;
sample2(sample2==0) = 0.0000001;

% [sample1_cdf,sample1_xvals] = ecdf(sample1);
% 
% 
% 
% [sample2_cdf,sample2_xvals] = ecdf(sample2);

totalXvals = unique([sample2;sample1]);

for iiXval = 1:numel(totalXvals);
    sample1_ecdf(iiXval) = nnz(sample1<=totalXvals(iiXval))./numel(sample1);
        sample2_ecdf(iiXval) = nnz(sample2<=totalXvals(iiXval))./numel(sample2);
end
clf
hold on;
stairs(totalXvals,sample1_ecdf);
stairs(totalXvals,sample2_ecdf);
%%
[Dplus,DplusPos] = max(sample2_ecdf-sample1_ecdf);
[Dminus,DminusPos] = max(-sample2_ecdf+sample1_ecdf);
plot([totalXvals(DminusPos),totalXvals(DminusPos)],[sample2_ecdf(DminusPos),sample1_ecdf(DminusPos)],'ro');
plot([totalXvals(DplusPos),totalXvals(DplusPos)],[sample2_ecdf(DplusPos),sample1_ecdf(DplusPos)],'bo');

n = min(numel(sample1),numel(sample2));
normalizedVn = sqrt(n)*(Dplus+Dminus);
title(['$$\sqrt{N} \cdot V_N = ',num2str(normalizedVn),'$$'],'interpreter','latex');
% sqrt(71)*(Dplus+Dminus)
alpha = (8*normalizedVn^2 - 2) *(exp (-2*normalizedVn^2) )


