function Stack_Thresholder_v4(Image)
    Thresh = graythresh(Image);
    factor = 2;
    hfig = figure();
    ax = axes('Parent',hfig,'position',[0.13 0.39  0.77 0.54]);
    h = imshowpair(Image(:,:,1), Image(:,:,1) > Thresh*factor);
    slider = uicontrol('Parent', hfig,'Style','slider',...
             'Units','normalized',...
             'Position',[0.31 0.15 0.4 0.05],...
             'Tag','slider',...
             'value',factor, ...
             'min',0, 'max',30,...
             'Callback',@slider_callback);
     
    txt = uicontrol('Style','text',...
         'Units','normalized',...
        'Position',[0.44 0.07 0.15 0.08],...
        'String','Adjust Threshold');
         
    slider2 = uicontrol('Parent', hfig,'Style','slider',...
         'Units','normalized',...
         'Position',[0.31 0.25 0.4 0.05],...
         'Tag','slider2',...
         'value',1, ...
         'min',1, 'max',size(Image,3),...
         'SliderStep', [1/size(Image,3) 10/size(Image,3)], ...
         'Callback',@slider2_callback);
     
    txt = uicontrol('Style','text',...
         'Units','normalized',...
        'Position',[0.44 0.22 0.15 0.03],...
        'String','Z-Slice');

    button = uicontrol('Parent', hfig,'Style','pushbutton',...
             'Units','normalized',...
             'Position',[0.46 0.01 0.1 0.05],...
             'String','Enter',...
             'Callback',@button_callback);
    
    function slider_callback(hObject,~) %threshold
        Current_Thresh = findobj('Tag','slider');
        Current_Thresh = Current_Thresh.Value;
        Current_Stack = findobj('Tag','slider2');
        Current_Slice = round(Current_Stack.Value);
        update_image = Image(:,:,Current_Slice) > Thresh*(Current_Thresh);
        imshowpair(Image(:,:,Current_Slice),update_image);
        data = Current_Thresh;
        hObject.UserData = data;
    end

    function slider2_callback(hObject,~) %Slicer
        Current_Slice = findobj('Tag','slider2');
        Current_Slice = Current_Slice.Value;
        Current_Slice = round(Current_Slice);
        Slider_Thresh = findobj('Tag','slider');
        Current_Thresh = round(Slider_Thresh.Value);
        update_image = Image(:,:,Current_Slice) > Thresh*(Current_Thresh);
        imshowpair(Image(:,:,Current_Slice),update_image);
        data = Current_Slice;
        hObject.UserData = data;
    end

    function button_callback(~,~)
	h = findobj('Tag','slider');
	data = h.UserData;
    assignin('base', 'F1', data);
    close(hfig)
    end
end