# encoding: utf-8
from __future__ import print_function

import matplotlib
matplotlib.use('Agg')
import pandas as pd

from brian2 import *

from parameter_exploration import run_exploration

# Global options for all benchmarks
resolution = 300
runtime = 1000*ms
repetitions = 3

if __name__ == '__main__':
    g_na_values = np.linspace(10, 100, num=resolution)
    I_values = np.linspace(0, 20, num=resolution)
    benchmark_results = []

    # Brian 2
    for threads in [0, 12]:
        for trial in range(repetitions):
            all_g_na_values, all_I_values, rates, took = run_exploration(runtime, g_na_values, I_values,
                                                                         target='cpp_standalone',
                                                                         threads=threads)
            print('Running the {resolution}×{resolution} parameter exploration with '
                  'Brian 2 ({threads} threads) took {took:.2f}s.'.format(resolution=resolution,
                                                                         threads=threads,
                                                                         took=took))
            results = pd.DataFrame({'g_Na': all_g_na_values,
                                    'I': all_I_values,
                                    'firing_rate': rates})
            # Only store results from a single trial
            if trial == 0 and threads == 0:
                results.to_csv('results/Brian2_parameter_exploration.csv')
            benchmark_results.append({'simulator': 'Brian2',
                                      'threads': threads,
                                      'trial': trial,
                                      'resolution': resolution,
                                      'runtime': runtime/ms,
                                      'took': took})
            device.reinit()

    # Brian2GeNN
    for trial in range(repetitions):
        all_g_na_values, all_I_values, rates, took = run_exploration(runtime, g_na_values, I_values,
                                                                     target='brian2genn')
        print('Running the {resolution}×{resolution} parameter exploration with '
              'Brian2GeNN took {took:.2f}s.'.format(resolution=resolution,
                                                    took=took))
        results = pd.DataFrame({'g_Na': all_g_na_values,
                                'I': all_I_values,
                                'firing_rate': rates})
        benchmark_results.append({'simulator': 'Brian2GeNN',
                                  'trial': trial,
                                  'resolution': resolution,
                                  'runtime': runtime/ms,
                                  'took': took})
        device.reinit()
    results_df = pd.DataFrame(benchmark_results)
    results_df.to_csv('results/parameter_exploration_benchmark_results.csv')
