% This script creates Figure 7B
%  Samora Okujeni 5/22/2019
%
%% load the data
load('data_ptx_development.mat')

% fields:
%
% all       matrix 
%           row 1: 'PKC treatment (1: PKC-, 2: PKCN, 3: PKC+)'  
%           row 2: 'DIV'  
%           row 3: 'average SBE strength (before PTX)'
%           row 4: 'average SBE strength (after 10muM PTX)'
%

%% plot the data
col = [[1 0 0];[0 0 0];[0 0.5 0]];
figure, hold on;
for ii=1:3,
    id = find(data.all(1,:)==ii);
    [~,sortid] = sort(data.all(2,id));
    plot(data.all(2,id(sortid)),data.all(4,id(sortid))./data.all(3,id(sortid)),'o','Color',col(ii,:),'MarkerFaceColor',col(ii,:),'MarkerSize',5);
end

plot([0 100],[1 1],'k-');
set(gca,'YScale','log','YLim',[1e-3 1e3],'XLim',[0 55]);
ylabel('rel. change');
axis square;

% moving average
ma = 7; % find data points within this div range for moving average
ddiv = nan(55,1);
for ii=1:length(ddiv), 
    ddiv(ii) = nanmean(log10(data.all(4,find(data.all(2,:)>=ii-ma+1 & data.all(2,:)<=ii+ma))./data.all(3,find(data.all(2,:)>=ii-ma+1 & data.all(2,:)<=ii+ma)))); 
end
data.all(data.all(2,:)>55,:) = nan;
for cc = 1:3,
    id = find(data.all(1,:)==cc);
    for ii=1:length(ddiv),
        ddiv(ii) = nanmean(log10(data.all(4,find(data.all(1,:)==cc & data.all(2,:)>=ii-ma+1 & data.all(2,:)<=ii+ma))./data.all(3,find(data.all(1,:)==cc & data.all(2,:)>=ii-ma+1 & data.all(2,:)<=ii+ma))));
    end
    ddiv = 10.^ddiv;
    ma_x = find(~isnan(ddiv));
    s1 = min(ma_x)+ma; s2 = max(ma_x)-ma+1;
    ma_y = ddiv(~isnan(ddiv));
    s3 = find(ma_x>=s1 & ma_x<=s2);
    hold on; plot(ma_x(s3),ma_y(s3),'b','Color',col(cc,:),'LineWidth',2);
end
grid on       
set(gca,'TickDir','out');

%% Statistics
% after 20 DIV
divrange = [[0 14];[21 inf]];
clear baseline_mean baseline_sem afterptx_mean afterptx_sem
for ii=1:size(divrange,1),
    for jj=1:3, % cda
        id = (data.all(2,:)>=divrange(ii,1)) & (data.all(2,:)<=divrange(ii,2)) & (data.all(1,:)==jj);
        baseline_mean(ii,jj)  = mean(data.all(3,id));
%         baseline_std(ii,jj) = std(data.all(3,id));
        baseline_sem(ii,jj) = std(data.all(3,id))/sqrt(sum(id));
        
        afterptx_mean(ii,jj)  = mean(data.all(4,id));
%         afterptx_std(ii,jj) = std(data.all(4,id));
        afterptx_sem(ii,jj) = std(data.all(4,id))/sqrt(sum(id));
        
        ratio_mean(ii,jj) =   mean(data.all(4,id)./data.all(3,id));
%         ratio_std(ii,jj) =   std(data.all(4,id)./data.all(3,id));
        ratio_sem(ii,jj) =   mean(data.all(4,id)./data.all(3,id))/sqrt(sum(id));
        
        [~,p(ii,jj)]=ttest(data.all(4,id),data.all(3,id));
        n(ii,jj) = sum(id);
    end
end
% create table and disp statistics
divrange_names = {'before 14 DIV','after 21 DIV'};
for ii=1:2;
    clear T
    for jj=1:size(baseline_mean,2),
        T{1,jj} = [num2str(baseline_mean(ii,jj),'%10.2e\n') ' ' char(177) ' ' num2str(baseline_sem(ii,jj),'%10.2e\n')];
        T{2,jj} = [num2str(afterptx_mean(ii,jj),'%10.2e\n') ' ' char(177) ' ' num2str(afterptx_sem(ii,jj),'%10.2e\n')];
        T{3,jj} = [num2str(ratio_mean(ii,jj),'%10.2e\n') ' ' char(177) ' ' num2str(ratio_sem(ii,jj),'%10.2e\n')];
        T{4,jj} = [num2str((ratio_mean(ii,jj)-1)*100,3) ' ' char(177) ' ' num2str(ratio_sem(ii,jj)*100,3)];
        T{5,jj} = [num2str(p(ii,jj),'%10.2e\n')];
        T{6,jj} = [num2str(n(ii,jj))];
    end
    T = array2table(T,'VariableNames',{'Goe6976','Control','PMA'},'RowNames',{'baseline','after PTX','ratio 2 baseline','percent change','p-value','n'});
    disp('----------------------');
    disp(divrange_names{ii});
    disp(T);
end
        