% This script creates Figure 5D, E
%  Samora Okujeni 5/22/2019
%
%% load the data
load('G:\Dropbox (Biomicrotechnology)\Users\Okujeni\Data\Publications\Paper\Paper_development 2019\figures_elife\Data\data_patchclamp.mat');
%
% fields
% cda:              1: Goe6976, 2: Control (chronic drug application), for every neuron
% div:              days in vitro for every neuron
% mp_bins:          membrane potential binning
% mp_mat            matrix with membrane potential distributions for every neuron
%
%%
plot_all = 0; % set to 1 to plot distributions for every recording (not averaged across PKC conditions)

% plot distributions
k = 3; % slightly smoothen membrane potential distributions?
for ii = 1:size(data.mp_mat,1),
    mp_mat(ii,:) = filtfilt(ones(k,1)/k,1,data.mp_mat(ii,:));
end
figure, hold on,
if plot_all
    plot(data.mp_bins,mp_mat(data.cda==1,:),'r-');
    plot(data.mp_bins,mp_mat(data.cda==2,:),'k-');
    plot(data.mp_bins,mp_mat(data.cda==3,:),'g-');
end
plot(data.mp_bins,(mean(mp_mat(data.cda==1,:))),'r','LineWidth',2);
plot(data.mp_bins,(mean(mp_mat(data.cda==2,:))),'k','LineWidth',2);
plot(data.mp_bins,(mean(mp_mat(data.cda==3,:))),'g','LineWidth',2);

% look for significant deviations in the distributions of PKC^N and PKC^- neurons
[~, sig] = ttest2(mp_mat(data.cda==2,:),mp_mat(data.cda==1,:));
theta = 0.05;
sig(sig>theta) =  nan;
sig(sig<=theta) = 1;
sig(data.mp_bins<-60) = nan; % baseline
plot(data.mp_bins,sig.*(mean(mp_mat(data.cda==1,:))),'r','LineWidth',5);

% look for significant deviations in the distributions of PKC^N and PKC^+ neurons
[~, sig] = ttest2(mp_mat(data.cda==2,:),mp_mat(data.cda==3,:));
theta = 0.05;
sig(sig>theta) =  nan;
sig(sig<=theta) = 1;
sig(data.mp_bins<-60) = nan; % baseline
plot(data.mp_bins,sig.*(mean(mp_mat(data.cda==3,:))),'g','LineWidth',3);

% text, labels and format
hold on; plot([-40 -40],[1e-6 1],'k:');
hold on; plot([-0 -0],[1e-6 1],'k:');
hold on; plot([-65 -65],[1e-6 1],'k:');
text(-60,0.5,'subthreshold','HorizontalAlignment','Center')
text(-20,0.5,'plateau','HorizontalAlignment','Center')
text(20,0.5,'action potential peaks','HorizontalAlignment','Center')
set(gca,'TickDir','out');
xlabel('membrane potential'); ylabel('fraction');
set(gca,'YScale','log','YLim',[1e-6 1e-0],'XLim',[-80 40]);
