% This script creates Figure 5A-C, 6F, 7A and table 2
%  Samora Okujeni 5/22/2019
%
%% load the data
load('data_mea_development.mat');
%
% fields:
% all       matrix 
%           row 1: PKC treatment (1: PKC-, 2: PKCN, 3: PKC+)  
%           row 2: DIV
%           row 3: AFR (average firing rate)'
%           row 4: SBE rate
%           row 5: SBE strength
%           row 6: PFR (average peak firing rate)
%           row 7: correlation (average spike train correlation between all pairs of active electrodes, 30ms bins)

%% plot data
col = [[1 0 0];[0 0 0];[0 0.5 0]];
sig = {'','*','**','***'};
div_bins = cumsum(2:10)+1; 
d = diff(div_bins)/2; 
div_bins(end) = inf;
for pp=6,
    % average data for specified time windows and PKC conditions
    parameter_mean  = nan(3,7);
    parameter_sem   = nan(3,7);
    for ii=1:3, 
        for jj=1:length(div_bins)-1, 
            id_con = find([(data.all(2,:)>=div_bins(jj)) & (data.all(2,:)<div_bins(jj+1)) & (data.all(1,:)==2)]); % index for controls within specified developmental time window
            id = find([(data.all(2,:)>=div_bins(jj)) & (data.all(2,:)<div_bins(jj+1)) & (data.all(1,:)==ii)]); % index for specified treatment within specified developmental time window
            
            parameter_mean(ii,jj) = nanmean(data.all(pp,id));                     % mean
            parameter_sem(ii,jj) = nanstd(data.all(pp,id))/sqrt(length(id));      % sem
            [~,parameter_p(ii,jj)] = ttest2(data.all(pp,id),data.all(pp,id_con)); % significance
            n(ii,jj) = length(id);
        end, 
    end; 
    % plot 
    figure, hold on; 
    for ii=1:3, 
        errorbar(div_bins(1:end-1)+d,parameter_mean(ii,:),parameter_sem(ii,:),parameter_sem(ii,:),'Color',col(ii,:)); 
        if ii~=2
            text(div_bins(1:end-1)+d,parameter_mean(ii,:)+1.1*parameter_sem(ii,:),sig(1+(parameter_p(ii,:)<=0.05)+(parameter_p(ii,:)<=0.01)+(parameter_p(ii,:)<=0.001)),'Color',col(ii,:),'HorizontalAlignment','Center'); 
        end
    end
    title(data.entries{pp});
    legend('PKC^-','PKC^N','PKC^+');
    set(gca,'XLim',[0 55],'XTick',div_bins);

    % display Statistics
    clear T
    for ii=1:size(parameter_mean,1)
        for jj=1:size(parameter_mean,2),
            if ii~=2
                T{jj,ii} = [num2str(parameter_mean(ii,jj),'%10.2e\n') ' ' char(177) ' ' num2str(parameter_sem(ii,jj),'%10.2e\n') ' (p=' num2str(parameter_p(ii,jj),'%10.2e\n') ', n=' num2str(n(ii,jj)) ')'];
            else
                T{jj,ii} = [num2str(parameter_mean(ii,jj),'%10.2e\n') ' ' char(177) ' ' num2str(parameter_sem(ii,jj),'%10.2e\n') ' (n=' num2str(n(ii,jj)) ')'];
            end
        end
    end
    T = array2table(T,'VariableNames',{'Goe6976','Control','PMA'},'RowNames',{'3-5 DIV','6-9 DIV','10-14 DIV','15-20 DIV','21-27 DIV','28-35 DIV','36-44 DIV','45+ DIV'});
    disp('---------------------------');
    disp(data.entries{pp});
    disp(T);
    disp('---------------------------');
end