function [estimates, model] = fit_exponent(xdata, ydata)
% Call fminsearch with a random starting point.
% start_point = 0.1;
start_point = 0.1;
model = @expfun;
MaxFunEvals = 100000;
MaxIter = 100000;

options = optimset('fminsearch');
options.MaxFunEvals = MaxFunEvals;
options.MaxIter = MaxIter;
estimates = fminsearch(model, start_point,options);

    function [sse, FittedCurve] = expfun(params)
        FittedCurve = exp(params(1)*xdata)-1;
        ErrorVector = FittedCurve - ydata;
        sse = sum(ErrorVector .^ 2);
    end
end