function [mask1, mask2] = bpassLine (image, w, l)
% uses bandpass filter to find linear objects of any direction
% image can be sequence
% w is width, l is length of fibers

image = squeeze(image);

% generate line filters
N = 2*w + 1;
x = 0:N-1;
r = (w - x)/2;
fx = exp( -r.^2) / (2 * sqrt(pi));
extra = round(1.3*N - N);
fx = repmat(fx, [2*extra + N + (l-w), 1]); % make it bigger to allow rotation
fx = padarray(fx, [0, extra+(l-w)/2]);
fx = fx./sum(fx(:));

% rotate around
angleStep = 18;
angles = round(180/angleStep);
f = zeros(size(fx,1), size(fx,2), angles);
for m = 1:angles
    
    angle = (m-1)*angleStep;
    tform = affine2d([cosd(angle), -sind(angle), 0; sind(angle), cosd(angle), 0; 0,0,1]);
    temp = imwarp(fx, tform);
    offset = (size(temp,1)-size(fx,1))/2;
    f(:,:,m) = temp(floor(offset)+1:end-ceil(offset), floor(offset)+1:end-ceil(offset));
    
end

% recrop the extra away

f = f(extra+1:end-extra, extra+1:end-extra,:);
f = f./(repmat(sum(sum(f)), [N+(l-w),N+(l-w),1]));
b = ones(size(f,1), size(f,2))/(N+(l-w))^2;

mask1 = zeros(size(image));
mask2 = zeros(size(image));


for frame = 1:size(image,3);
    
    % filter with all the line directions
    maskTemp = zeros(size(image,1), size(image,2), angles);
    bckg = conv2(image(:,:,frame),b,'valid');
    for m=1:angles
        
        maskTemp(w+(l-w)/2+1:end-w-(l-w)/2,w+1+(l-w)/2:end-w-(l-w)/2,m) = conv2(image(:,:,frame),f(:,:,m),'valid') - bckg;
        
    end
    
    mask1(:,:,frame) = max(maskTemp,[],3);
    mask2(:,:,frame) = max(maskTemp,[],3) - min(maskTemp,[],3);
    
end

