function mask = bpassseq (image,sz)
% use bandpass (bpass) to filter image sequence

if nargin<2
    sz = 5;
end

thirdD = ndims(image);
image = squeeze(image);

if size(image,3)>50 %use waitbar only if the sequence is long
    h = waitbar (0, 'Filtering image...');
end

mask = zeros(size(image));
for frame = 1:size(image,3)
    mask (:,:,frame) = bpass(image(:,:,frame),1,sz);
    
    if size(image,3)>50
        waitbar (frame/size(image,3))
    end
end

if size(image,3)>50
    close (h)
end

if thirdD > 3
    mask = reshape(mask, [size(image,1), size(image,2), 1, size(image,3)]);
end
    