function image = read_image_sequence (file_name, frame)   %image = read_image_sequence (file_name)
% frame can be a list of frames to read

if strcmp(file_name(end-2:end), 'tif') || strcmp(file_name(end-2:end), 'TIF')
    
    if exist('frame', 'var') % read only specified frames
        info = imfinfo(file_name);
        x = info(1).Width;
        y = info(1).Height;
        image = zeros (y,x,1,numel(frame));
        
        for f = 1:numel(frame)
            image(:,:,1,f) = double(imread (file_name, frame(f)));
        end
        return
        
    else
        
        % read all frames in a loop
        info = imfinfo(file_name);
        m = length(info);
        x = info(1).Width;
        y = info(1).Height;
        image = zeros (y,x,1,m);
        
        for f = 1:m
            image(:,:,1,f) = imread (file_name, f);
        end
    end
    
else
    
%==========================================================================
%
% the following import works with MetaMorph stk-files, with ImageJ tif-stacks
% and also with Zeiss LSM images. 
% Only Image Pro completely screws up the tif format
%
% full support for Zeiss LSM and SPE fiels (native Roper file format) will
% follow soon
%
% changed 070830 00.70  Tobias Meckel
%
%==========================================================================

    [stack, img_read] = tiffread2(file_name);

    m = img_read;
    x = stack(1).width;
    y = stack(1).height;
    
    image = zeros (y,x,1,m);

    for frame = 1:m
        image(:,:,1,frame) = stack(frame).data;
    end
end