#-------------------------------------------------------------
### import data for all subjects -----------------------------

library(plyr)

forageDat = as.data.frame(data.table::fread(file.choose())) # select forageDat.csv file

# some processing...
experiments = unique(forageDat$Experiment)

leaveDat = subset(forageDat, Decision==1)
mean_rat = ddply(as.data.frame(leaveDat), .(Subject, Experiment, Treatment, startVolume), function(x) c(presses = mean(x$PriorPresses), sd = sd(x$PriorPresses)))
mean_rat$Treat_Labels = factor(mean_rat$Treatment,
                               levels = c("Travel_10", "Travel_30", "deplete_8", "deplete_16", "single", "double", "HT_0", "HT_3", "ITI_3", "ITI_12"),
                               labels = c("10s", "30s", "8uL", "16uL", "90uL/10s", "180uL/20s", "0s", "3s", "3.s", "12.s"))
mean_rat$Exp_Labels = factor(mean_rat$Experiment,
                             levels = c("Travel", "Deplete", "Scale", "HT"),
                             labels = c("travel time", "depletion rate", "scale", "handling time"))
mean_condition = ddply(mean_rat, .(Experiment, Treatment), function(x) c(mean = mean(x$presses), sd = sd(x$presses)))
#-------------------------------------------------------------

#-------------------------------------------------------------
### mixed effects models ----------

library(lmerTest)

lmer_travel = lmer(data=subset(leaveDat, Experiment=="Travel"), PriorPresses ~ startVolume*factor(TravelTime) + (startVolume+factor(TravelTime) || Subject),
                   control=lmerControl(optimizer="nmkbw"))
summary(lmer_travel)

#----

lmer_deplete = lmer(data = leaveDat, subset = Experiment =="Deplete", PriorPresses ~ Treatment + (Treatment | Subject))
summary(lmer_deplete)

#----

lmer_scale = lmer(data = leaveDat, subset =  Experiment =="Scale", PriorPresses ~ Treatment + (Treatment | Subject))
summary(lmer_scale)

#----

lmer_ht = lmer(data = leaveDat, subset =  Experiment =="HT", PriorPresses ~ Treatment + (Treatment | Subject))
summary(lmer_ht)

#----

lmer_iti = lmer(data = leaveDat, subset =  Experiment =="ITI", PriorPresses ~ Treatment + (Treatment | Subject))
summary(lmer_iti)
