##########################################  
### import data from all subjects --------

library(data.table)

dAll = fread(file.choose()) # select itcDat.csv
dFree = dAll[ForceFree==1] # subset only free choice trials

# print number of free choice trials per subject per condition
dFree[, .N, c("Subject", "Condition")]

########################################## 

##########################################  
### mixed effects model

library(lmerTest)
library(phia)

# scale continuous predictor variables: LL reward and LL delay
dFreeLM = copy(dFree)
toScale = c("LL_reward", "LL_delay")
for(i in toScale) dFreeLM[, c(i) := scale(get(i))]

# fun logistic regression on choices (may take a minute...)
choiceLM = glmer(data=dFreeLM, chooseLL ~ LL_reward*LL_delay*Condition + (LL_reward+LL_delay+Condition || Subject),
                 family=binomial, nAGQ=0, control=glmerControl(optCtrl=list(maxfun=100000, iprint=1000)))
summary(choiceLM)
interactionMeans(choiceLM, slope="LL_reward")
testInteractions(choiceLM, fixed="Condition", slope="LL_reward")
interactionMeans(choiceLM, slope="LL_delay")
testInteractions(choiceLM, fixed="Condition", slope="LL_delay")
interactionMeans(choiceLM, pairwise="Condition", slope="LL_delay")
testInteractions(choiceLM, pairwise="Condition", slope="LL_delay")