//Author: Johan Slotman – j.slotman@erasmusmc.nl
//Erasmus MC Optical Imaging Center Rotterdam, The Netherlands
//Created 10/27/2017

//Goal: Returns FWHM values and fit (R^2) over perpendicular positioned ~2um segments along
//an axonal track

function fitGauss(){
	
	if(selectionType()!=5){return -1;}
	
	data=getProfile;
   	lengthx=lengthOf(data); 
   	ind=newArray(lengthx);
   	for(ix=0; ix<lengthx; ix++) {
		ind[ix]=ix;
		}
    	Fit.doFit("Gaussian",ind,data);
		out = newArray(2);
		
		
			
			out[0]=Fit.p(3)*2.35482;
			out[1]=Fit.rSquared;
		
		
    	
	return out; 

}



function trig_angle_absolute(a,o,s){
	if(isNaN(a) && !isNaN(o) && !isNaN(s)){return(asin(o/s)); }
	if(!isNaN(a) && isNaN(o) && !isNaN(s)){return(acos(a/s)); }
	if(!isNaN(a) && !isNaN(o) && isNaN(s)){
		
		angle = atan(o/a);
		
		if(a>=0 && o<0){angle = -angle;}
		if(a<0 && o<0){angle = (0.5*PI)+((PI/2)-angle);}
		if(a<0 && o>=0){angle = -angle+PI  ;}
		if(a>=0 && o>=0){angle = (1.5*PI)+((PI/2)-angle);}
		
		
		return(angle*(180/PI)); }

	print("An error occured");
	return -1;
}

function getCoordLine(X,Y,lengthF,lengthR,angle,make){

				coord=newArray(4);
					
				angle=angle*(PI/180);
				coord[0]=X+(cos(angle)*lengthF); //x1
				coord[1]=Y-(sin(angle)*lengthF); //y1
				coord[2]=X-(cos(angle)*lengthR); //x2
				coord[3]=Y+(sin(angle)*lengthR); //y2
				if(make==1){makeLine(coord[0],coord[1],coord[2],coord[3]);}
				return coord;
}

function fillsquare(x,y,start,size,col){
	setPixel((start%size)+x-floor(size/2),floor(start/size)+y-floor(size/2),col);
	if(start<(size*size)-1){
		fillsquare(x,y,start+1,size,col);
	}
}

p = File.openDialog("choose file");
f = File.open(p);


nROI = roiManager("count");
lookradius = 5;

imageID = getImageID();
getPixelSize(unit, pixelWidth, pixelHeight);
getDimensions(width, height, channels, slices, frames);

newImage("Heatmap measured", "8-bit composite-mode", width, height, 1, 1, nROI);
run("Fire");
heatmapID = getImageID();

newImage("Heatmap fittted", "8-bit composite-mode", width, height, 1, 1, nROI);
run("Fire");
heatmapID_fit = getImageID();




for(i=0;i<nROI;i++){

	Stack.setPosition(1,1,i+1);

	roiManager("select",i);

	if(selectionType()==7){

	getSelectionCoordinates(xpoints, ypoints);

	fwhm_array = newArray(xpoints.length);
	fwhmFit_array = newArray(xpoints.length);

	dist = 0;

	selectImage(imageID);
		
	for(j=0;j<xpoints.length;j++){

		if(j==0){
			dist=0;
		}else{
			dist = dist + ( sqrt( pow(xpoints[j]-xpoints[j-1],2) + pow(ypoints[j]-ypoints[j-1],2) ) * pixelWidth );
		}
		

		if(j<lookradius+1){
			x1 = xpoints[j];
			y1 = ypoints[j];
			x2 = xpoints[j+((2*lookradius)+1)];
			y2 = ypoints[j+((2*lookradius)+1)];
					
		}
		if(j>lookradius+1 && j<xpoints.length-(lookradius+1)){
			x1 = xpoints[j-lookradius];
			y1 = ypoints[j-lookradius];
			x2 = xpoints[j+lookradius];
			y2 = ypoints[j+lookradius];
		}
		if(j>=xpoints.length-(lookradius+1)){
			x1 = xpoints[j];
			y1 = ypoints[j];
			x2 = xpoints[j-(2*lookradius)+1];
			y2 = ypoints[j-(2*lookradius)+1];
		}

		
		
		angle = trig_angle_absolute(x1-x2,y1-y2,"n");
		getCoordLine(xpoints[j],ypoints[j],25,25,angle+90,1);
		roiManager("add");
		gfit = fitGauss();
		intProfile = getProfile();
		Array.getStatistics(intProfile, min, max, mean, stdDev);
		foundLeft = false;
		foundRight = false;
		halfmax = max/2;
		
		for(k=0;k<intProfile.length;k++){

			if(intProfile[k]>halfmax && !foundLeft){
				leftInd = k;
				foundLeft = true;
			}
			if(intProfile[intProfile.length-k-1]>halfmax && !foundRight){
				rightInd = intProfile.length-k-1;
				foundRight = true;
			}
			
		}

		//linear regression

		x_l = (intProfile[leftInd+1]-intProfile[leftInd])/halfmax;
		x_r = (intProfile[rightInd-1]-intProfile[rightInd])/halfmax;		

		fwhm = ((rightInd-x_r) - (leftInd+x_l))*pixelWidth;
		fwhmFit = gfit[0]*pixelWidth;
		print(fwhmFit);
		fwhm_array[j] = floor((fwhm - 0.100)/(2-0.100)*255);
		fwhmFit_array[j] = floor((fwhmFit - 0.100)/(2-0.100)*255);
		
		

		print(f,i+"\t"+j+"\t"+xpoints[j]+"\t"+ypoints[j]+"\t"+dist+"\t"+fwhm+"\t"+fwhmFit+"\t"+gfit[1]); // gfit[1]= rsquared
		
	}
	
	selectImage(heatmapID);
	
	for(j=0;j<xpoints.length;j++){
		fillsquare(xpoints[j],ypoints[j],0,2,fwhm_array[j]);
	}

	selectImage(heatmapID_fit);
	
	for(j=0;j<xpoints.length;j++){
		print(fwhmFit_array[j]);
		fillsquare(xpoints[j],ypoints[j],0,2,fwhmFit_array[j]);
	}
	

	}else{
		print("selection "+i+" is not freehand");
		
	}

	
}

File.close(f);
