# NewAgeBob (NAB)

This is the current replacement for the multithreaded version of the bob code.  Currently under
active development.

## Making NAB

### Dependencies
Mac:
* brew install gsl glew python python3 gcc libyaml fftw glfw xquartz freeglut libpng png++ 


The basics of making NAB on your machine should be fairly simple, although it can change depending
on what platform you are compiling on.  The possible (main) files to compile are:

* crosslink_sphero_bd_mp
* spindle_bd_mp
* sphero_movie
* spindle_analysis_new
* Any others defined in the Makefile

The generic form is 
    make CFG=release THREADING=omp -j<n> <program>

For compilation on rumor or the supercomputer
rumor:
    make CFG=release THREADING=omp -j<n> NOGRAPH=true <program>
summit:
    make CFG=release THREADING=omp -j<n> NOGRAPH=true LOC=Summit <progam>

## Specific Programs

Many programs share features, so check into that.  Mostly, if you run with the -h flag, you should
get some idea of what the program can do.  Listed later here are examples.  Restarting mostly involves passing
the -r flag with a frame number (minus 1, for example, if there are 10 frames, give it 9 to read the last one),
followed by the -p flag for however many posit files there happen to be (end stage ones).

### crosslink_sphero_bd_mp

Normal run:
    crosslink_sphero_bd_mp default.yaml equil.yaml opt.yaml

Restart run:
    crosslink_sphero_bd_mp default.yaml equil.yaml opt.yaml -r 9 -p sphero.posit -p crosslinks

## sphero_movie

Normal run:
    sphero_movie default.yaml equil.yaml opt.yaml -p sphero.posit -p sphero.crosslinks.0

### spindle_bd_mp

Normal run:
    spindle_bd_mp spindle_bd_mp.default.yaml spindle_bd_mp.equil.yaml

Restart run: Note this takes names for the crosslinks and chromosomes, since there are multiple files
    spindle_bd_mp spindle_bd_mp.default.yaml spindle_bd_mp.equil.yaml -r 9 -p spindle_bd_mp.posit -p crosslinks.final -p chromosomes.final

## Git Stuff

When making your own branch for work, do this:

### New Branch

    git checkout -b <branch_name>
    git push origin <branch_name>
    git pull (should complain, do what it says)
    git pull

### Existing Branch
    git checkout -b <branch_name> origin/<branch_name>
example:
    git checkout -b analysis origin/analysis

### Updating <branch_name> to include changes to master

    git stash
    git checkout master
    git pull
    git checkout <branch_name>
    
Then you have a choice.  You can either do a merge, a rebase, or apply the stash.

1) Merge then apply stash
    git merge master
    git stash pop

2) Rebase then apply stash
    git rebase master
    git stash pop

3) Stash apply then rebase/merge
    git stash pop
    git merge/rebase master

### Typical Workflow (branch foo)
    git fetch --all
    git checkout master
    git pull
    git checkout foo
    git pull
    git rebase master
    <fix conflicts>
    git checkout master
    git merge


