# Making movies from the blurred images and stuff
#ffmpeg -y -f image2 -i snapshot_%5d.png -vcodec libx264 -profile baseline -pix_fmt yuv420p -r 15 -qscale -0.8 $1
#ffmpeg -y -f image2 -i mt_gaussian_2dblur_%5d.png -vcodec libx264 -profile baseline -pix_fmt yuv420p -r 15 -qscale -0.8 mt_gaussian_2dblur.mov
#ffmpeg -y -f image2 -i kc_gaussian_2dblur_%5d.png -vcodec libx264 -profile baseline -pix_fmt yuv420p -r 15 -qscale -0.8 kc_gaussian_2dblur.mov
#ffmpeg -y -f image2 -i cut7_gaussian_2dblur_%5d.png -vcodec libx264 -profile baseline -pix_fmt yuv420p -r 15 -qscale -0.8 cut7_gaussian_2dblur.mov

# Combinging the 4 into a single movie
#ffmpeg \
#  -i $1 -i mt_gaussian_2dblur.mov -i kc_gaussian_2dblur.mov -i cut7_gaussian_2dblur.mov \
#  -filter_complex " \
#    nullsrc=size=1600x1600 [base]; \
#    [0:v] setpts=PTS-STARTPTS, scale=800x800 [upperleft]; \
#    [1:v] setpts=PTS-STARTPTS, scale=800x800 [upperright]; \
#    [2:v] setpts=PTS-STARTPTS, scale=800x800 [lowerleft]; \
#    [3:v] setpts=PTS-STARTPTS, scale=800x800 [lowerright]; \
#    [base][upperleft] overlay=shortest=1 [tmp1]; \
#    [tmp1][upperright] overlay=shortest=1:x=800 [tmp2]; \
#    [tmp2][lowerleft] overlay=shortest=1:y=800 [tmp3]; \
#    [tmp3][lowerright] overlay=shortest=1:x=800:y=800 \
#  " \
#  -c:v libx264 combined.mov

# Making a movie with the frames numbered
#ffmpeg -y -f image2 -i mt_gaussian_2dblur_%5d.png -vcodec libx264 -profile baseline -pix_fmt yuv420p \
#  -vf "drawtext=fontfile=Arial.ttf: text=%{n}: x=(w-tw)/2: y=h-(2*lh): fontcolor=white: box=1: boxcolor=0x00000099" \
#  -r 15 -qscale -0.8 mt_blur.mov

#ffmpeg \
#  -i microtubule_microscopy.mov -i kinetochore_microscopy.mov -i merge_microscopy.mov \
#  -filter_complex " \
#    nullsrc=size=200x600 [base]; \
#    [0:v] setpts=PTS-STARTPTS, scale=200x200 [upperleft]; \
#    [1:v] setpts=PTS-STARTPTS, scale=200x200 [upperright]; \
#    [2:v] setpts=PTS-STARTPTS, scale=200x200 [lowerleft]; \
#    [base][upperleft] overlay=shortest=1 [tmp1]; \
#    [tmp1][upperright] overlay=shortest=1:y=200 [tmp2]; \
#    [tmp2][lowerleft] overlay=shortest=1:y=400 \
#    " \
#    -c:v libx264 stacked.mov

#ffmpeg \
#  -i microtubule_microscopy.mov -i kinetochore_microscopy.mov -i merge_microscopy.mov \
#  -filter_complex " \
#    nullsrc=size=600x200 [base]; \
#    [0:v] setpts=PTS-STARTPTS, scale=200x200 [upperleft]; \
#    [1:v] setpts=PTS-STARTPTS, scale=200x200 [upperright]; \
#    [2:v] setpts=PTS-STARTPTS, scale=200x200 [lowerleft]; \
#    [base][upperleft] overlay=shortest=1 [tmp1]; \
#    [tmp1][upperright] overlay=shortest=1:x=200 [tmp2]; \
#    [tmp2][lowerleft] overlay=shortest=1:x=400 \
#    " \
#    -c:v libx264 stacked.mov
#
#ffmpeg \
#  -i fixed_view.mov -i stacked.mov \
#  -filter_complex " \
#  nullsrc=size=800x1068 [base]; \
#  [0:v] setpts=PTS-STARTPTS, scale=800x800 [upperleft]; \
#  [1:v] setpts=PTS-STARTPTS, scale=800x267 [lowerleft]; \
#  [base][upperleft] overlay=shortest=1 [tmp1]; \
#  [tmp1][lowerleft] overlay=shortest=1:y=800 \
#  " \
#  -c:v libx264 stacked_combined.mov

SpindleAnalysis -sd -m planar
mv $1 planar_view.mov

# Do one with the 3 images to the right side
ffmpeg \
  -i planar_view.mov -i microtubule_microscopy.mov -i kinetochore_microscopy.mov -i merge_microscopy.mov \
  -filter_complex " \
  nullsrc=size=1200x900 [base]; \
  [0:v] setpts=PTS-STARTPTS, scale=900x900 [upperleft]; \
  [1:v] setpts=PTS-STARTPTS, scale=300x300 [upperright]; \
  [2:v] setpts=PTS-STARTPTS, scale=300x300 [middleright]; \
  [3:v] setpts=PTS-STARTPTS, scale=300x300 [lowerright]; \
  [base][upperleft] overlay=shortest=1 [tmp1]; \
  [tmp1][upperright] overlay=shortest=1:x=900 [tmp2]; \
  [tmp2][middleright] overlay=shortest=1:x=900:y=300 [tmp3]; \
  [tmp3][lowerright] overlay=shortest=1:x=900:y=600 \
  " \
  -c:v libx264 side_stacked_combined.mov
