#!/usr/bin/env python
# In case of poor (Sh***y) commenting contact adam.lamson@colorado.edu
# Basic
import sys, os, pdb
## Analysis
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
from mpl_toolkits.axes_grid1 import make_axes_locatable
import itertools
from math import *

'''
Name: graph_lib.py
Description: Library of commonly used helper functions for graphing
'''

def make_color_bar(ax, label = r'Number of Seeds',
                 cmap=mpl.cm.rainbow, v_min=0, v_max=1):
    divider = make_axes_locatable(ax)
    cax = divider.append_axes('right', size='5%', pad=0.1)
    cb = mpl.colorbar.ColorbarBase(cax, cmap=cmap,
            norm = mpl.colors.Normalize(vmin=v_min, vmax=v_max))
    cb.set_label(label)

def legend_outside(ax, loc='center left', anchor=(1.0, .5), set_ax_pos=True):
    # mpl.rcParams.update({'figure.autolayout':True})
    if set_ax_pos: ax.set_position([0.1, 0.1, 0.7, 0.8])
    ax.legend(loc=loc, bbox_to_anchor=anchor)


##########################################
if __name__ == "__main__":
    print "Not implemented yet"




