#!/usr/bin/env python
# Basic
import sys
import os
import pdb
# Analysis
# import pandas as pd
# import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
import yaml

'''
Name: Graph options
Description: A quick functions that sets frequently changing graph options using a yaml file or dictionary
Input: Either a path to a yaml file or a dictionary with the listed options
Output: The dictionary given or the dictionary created by the yaml file
'''

def Graph_Options(ax, config):
    g_opt = {}
    if type(config) is str:
        with open(config) as f:
            g_opt = yaml.load(f)

    elif type(config) is dict:
        g_opt = config

    for key, value in g_opt.items():
        if key == "SupTitle":
            ax.suptitle(value)
        if key == "Title":
            ax.set_title(value)
        if key == "x_label":
            ax.set_xlabel(value)
        if key == "y_label":
            ax.set_ylabel(value)
        if key == "ymin":
            ax.set_ylim(bottom=value)
        if key == "ymax":
            ax.set_ylim(top=value)
        if key == "xmin":
            ax.set_xlim(left=value)
        if key == "xmax":
            ax.set_xlim(right=value)

    return g_opt

def GetYamlDict(config):
    with open(config) as f:
        g_opt = yaml.load(f)
    return g_opt

##########################################
# if __name__ == "__main__":
    # print "Not implemented yet"




