#!/usr/bin/env python
# In case of poor (Sh***y) commenting contact adam.lamson@colorado.edu
# YOLO edelmaie@colorado.edu (too)
# Basic
import sys, os, pdb
import gc
## Analysis
import numpy as np
import yaml

import matplotlib.patches as patches
import matplotlib.lines as lines
import matplotlib as mpl

'''
Name: microtubule.py
Description:
Input:
Output:
'''

#Class definition
class Microtubule():
    def __init__(self, i):
        self.idx = i
        self.r = []
        self.u = []
        self.v = []
        self.l = 0
        self.spb = 0
        self.paired = 0.

    def __repr__(self):
        retrstring = "idx: {}, r: {}, u: {}, v: {}, l: {}, spb: {}, paired: {}".format(self.idx, self.r, self.u, self.v, self.l, self.spb, self.paired)
        return retrstring

    def Draw2DMT(self, ax, color=None):
        """ Puts a 2D spherocylinder on Matplotlib axis (ax) """
        s1, s2 = self.GetSites()
        #Get proper width of lines
        fig = ax.get_figure()
        bbox = ax.get_window_extent().transformed(fig.dpi_scale_trans.inverted())
        ax_w, ax_h = bbox.width, bbox.height
        ax_simlength = ax.get_xlim()[1] - ax.get_xlim()[0]

        inch_per_sig = ax_w/(ax_simlength)
        lw = 36*inch_per_sig
        
        angle = ((np.arctan(self.v[1]/self.v[0]) if self.v[0] >0 else (np.arctan(self.v[1]/self.v[0]) + np.pi)) + 1.5*np.pi) % (np.pi*2.0)
        norm = mpl.colors.Normalize(0.0, 2*np.pi)
        cmap = mpl.cm.hsv_r
        m = mpl.cm.ScalarMappable(norm=norm, cmap=cmap)
        # if color == None: color = mpl.cm.hsv(norm=norm, (angle/2*np.pi)
        if color == None: color = m.to_rgba(angle)
        line = lines.Line2D( (s1[0],s2[0]), (s1[1], s2[1]), 
                linewidth=lw, solid_capstyle = 'round', color=color, clip_on=False)
        ax.add_line(line)
        return

    def GetSites(self):
        """ Returns end points of MTs """
        s1 = self.r - self.v*.5
        s2 = s1 + self.v
        return s1, s2



