#!/usr/bin/env python
# In case of poor (Sh***y) commenting contact adam.lamson@colorado.edu
# YOLO edelmaie@colorado.edu (too)
# Basic
import sys, os, pdb
import gc
## Analysis
import numpy as np
import yaml

from operator import attrgetter

from scipy import special
import scipy.misc

# import pandas as pd
# import matplotlib.pyplot as plt
# import matplotlib as mpl
# from math import *

'''
Name: read_posit_base.py
Description:
Input:
Output:
'''

#Class definition
class ReadPositBase(object):
    def __init__(self, seed_path, posit_name, 
                 default_file='default.yaml', equil_file='equil.yaml'):

        self.seed_path = os.path.abspath(seed_path)
        self.posit_path = os.path.join(self.seed_path, posit_name)

        self.default_yaml = self.GetYamlDict(default_file)
        self.equil_yaml = self.GetYamlDict(equil_file)


    def GetYamlDict(self, file_name):
        file_path = os.path.join(self.seed_path, file_name)
        file_dict = ''
        with open(file_path, 'r') as stream: file_dict = yaml.load(stream)

        return file_dict

    def CheckDefaultThenEquil(self, key, val=None):
        if key in self.default_yaml:
            val = self.default_yaml[key]
        if key in self.equil_yaml:
            val = self.equil_yaml[key]
        if not val and val != 0:
            print '{} not in default or equil files.'.format(key)
            val = None
            #sys.exit(1)
        return val

    def LoadPosit(self):
        self.f_posit = open(self.posit_path)
        # pdb.set_trace()
        self.ReadPosHeader()
        self.CountFrames()

    def UnloadPosit(self):
        self.f_posit.close()

    def ReadPosHeader(self, headerdt):
        header = np.fromfile(self.f_posit, dtype=headerdt, count=1)[0]
        self.f_data_start = self.f_posit.tell()
        self.cur_frame = -1
        return header

    def CountFrames(self):
        """ Must have set self.configsize beforehand """
        old_file_position = self.f_posit.tell()
        self.f_posit.seek(0, os.SEEK_END)
        final_file_position = self.f_posit.tell()
        self.f_posit.seek(old_file_position, os.SEEK_SET)
        self.framesize = final_file_position - old_file_position
        self.nframes = self.framesize / self.configsize

    def ReadFramePosit(self):
        return np.fromfile(self.f_posit, dtype=self.framedt, count=1)[0]

    # A little name mangling
    __LoadPosit = LoadPosit
    __UnloadPosit = UnloadPosit
    __ReadPosHeader = ReadPosHeader
    __CountFrames = CountFrames
    __ReadRamePosit = ReadFramePosit

##########################################
if __name__ == "__main__":
    p = ReadPosit(sys.args[1], sys.args[2], sys.args[3], sys.args[4])
    print "Not implemented yet"




