#!/usr/bin/env python
# In case of poor (Sh***y) commenting contact adam.lamson@colorado.edu
# YOLO edelmaie@colorado.edu (too)
# Basic
import sys, os, pdb
import gc
## Analysis
import numpy as np
import yaml

from operator import attrgetter

from scipy import special
import scipy.misc

from read_posit_base import ReadPositBase
from gaussian_imaging import GaussianSpot2D
from chromosome import Chromosomes

# import pandas as pd
# import matplotlib.pyplot as plt
# import matplotlib as mpl
# from math import *

'''
Name: read_posit_chromosomes.py
Description:
Input:
Output:
'''

#Class definition
class ReadPositChromosomes(ReadPositBase):
    def __init__(self, seed_path, posit_name, 
                 default_file='default.yaml', equil_file='equil.yaml'):
        ReadPositBase.__init__(self, seed_path, posit_name, default_file, equil_file)

        self.chromosomes = None

    def LoadPosit(self):
        # Find the chromosome yaml file
        self.chromo_yaml_name = self.CheckDefaultThenEquil('chromosome_config')

        # Load the chromosome file
        with open(os.path.join(self.seed_path, self.chromo_yaml_name), 'r') as stream:
            self.chromo_yaml = yaml.load(stream)
            # Load the chromosomes
            if self.chromo_yaml['chromosomes']['chromosome']:
                self.chromosomes = Chromosomes(self.posit_path, self.chromo_yaml)
            
    def UnloadPosit(self):
        if self.chromosomes:
            self.chromosomes.UnloadPosit()

    def ReadFramePosit(self):
        # Defer to chromosome class
        if self.chromosomes:
            self.chromosomes.ReadFrame()

    def PrintFrame(self):
        if self.chromosomes:
            self.chromosomes.PrintFrame()

    ### Image Generation functionaltiy
    def ImageKinetochores2D(self, imageParams, h=None):
        #print "generating microtubule data"
        pixelSize = imageParams['pixelsize']
        noiseStd = imageParams['noisestd']
        bkglevel = imageParams['bkglevel']
        A = imageParams['A']
        sigma = imageParams['sigmaxy']
        offset_distance = imageParams['modeloffset']

        # Adjust sigma based on kinetochore size
        #sigma = sigma * self.chromo_yaml['chromosomes']['properties']['kc_diameter']/2.

        numPixelsX = np.int_(np.ceil((h[0][0]+offset_distance)/pixelSize))
        numPixelsY = np.int_(np.ceil((h[0][0]+offset_distance)/pixelSize))
        xpixels = np.arange(0,numPixelsX)
        ypixels = np.arange(0,numPixelsY)
        [x,y] = np.meshgrid(xpixels, ypixels)

        imagedata = bkglevel * np.ones((numPixelsX, numPixelsY)) \
                + np.random.standard_normal((numPixelsX, numPixelsY))*noiseStd

        #print "imagedata: {}".format(imagedata)
        
        # Loop over kinetochores
        # FIXME: Change to cen2 strain, where only ikc = 1 is imaged!
        for ikc in xrange(self.chromosomes.nkc):
            if ikc != 2 and ikc != 3:
                continue
            print "imaging kc {}".format(ikc)
            r0 = self.chromosomes.kinetochores[ikc].r
            x0 = r0[1]/pixelSize + numPixelsX/2
            y0 = r0[2]/pixelSize + numPixelsY/2

            derp = GaussianSpot2D(x, y, A, sigma, x0, y0)
            imagedata = imagedata + derp

        imagedata = np.fliplr(imagedata)
        return imagedata

    def ImageKinetochores2DPlanar(self, imageParams, h=None, rotation_matrix=None):
        #print "generating microtubule data"
        pixelSize = imageParams['pixelsize']
        noiseStd = imageParams['noisestd']
        bkglevel = imageParams['bkglevel']
        A = imageParams['A']
        sigma = imageParams['sigmaxy']
        offset_distance = imageParams['modeloffset']

        # Adjust sigma based on kinetochore size
        #sigma = sigma * self.chromo_yaml['chromosomes']['properties']['kc_diameter']/2.

        numPixelsX = np.int_(np.ceil((h[0][0]+offset_distance)/pixelSize))
        numPixelsY = np.int_(np.ceil((h[0][0]+offset_distance)/pixelSize))
        xpixels = np.arange(0,numPixelsX)
        ypixels = np.arange(0,numPixelsY)
        [x,y] = np.meshgrid(xpixels, ypixels)

        imagedata = bkglevel * np.ones((numPixelsX, numPixelsY)) \
                + np.random.standard_normal((numPixelsX, numPixelsY))*noiseStd

        #print "imagedata: {}".format(imagedata)
        
        # Loop over kinetochores
        for ikc in xrange(self.chromosomes.nkc):
            #if ikc != 2 and ikc != 3:
            #    continue
            r0 = np.dot(-rotation_matrix, self.chromosomes.kinetochores[ikc].r)
            x0 = r0[0]/pixelSize + numPixelsX/2
            y0 = r0[1]/pixelSize + numPixelsY/2

            derp = GaussianSpot2D(x, y, A, sigma, x0, y0)
            imagedata = imagedata + derp

        imagedata = np.fliplr(imagedata)
        return imagedata

    ### Generate distributions
    def GenerateKCSpindle1D(self, spbs, target_length=42.0, use_target = False):
        distances = np.array([])
        weights = np.array([])

        # Randomly choose to use spb0 or 1
        rspindle = spbs[1].r - spbs[0].r
        spindle_length = np.linalg.norm(rspindle)

        # Do a length check on the spindle 
        if (use_target and (spindle_length >= target_length-2.0) and (spindle_length <= target_length+2.0)) or \
            (not use_target and spindle_length > 40.0):
            # Just loop over kinetochores and get their information
            # Do this twice to force a symmetrization of the distribution! (we don't know which KC is the closest, so destroy
            # that information in the end)
            for ikc in xrange(self.chromosomes.nkc):
                r0 = self.chromosomes.kinetochores[ikc].r
                rkc = r0 - spbs[0].r # shift to common origin
                dist = np.dot(rkc, rspindle)/spindle_length
                distances = np.append(distances, dist)
                weights = np.append(weights, 1.0)
                ## Do the other spindle pole as a distance measure, as we want that information too!
                #rkc = r0 - spbs[1].r
                #dist = np.dot(rkc, -rspindle)/spindle_length
                #distances = np.append(distances, dist)
                #weights = np.append(weights, 0.5)


            distances = distances / spindle_length

        return [distances, weights]

    # What kind of attachments do we have on a per chromosome basis
    def GenerateAttachmentTypes(self, spbs, microtubules):
        # First, ask the chromosomes to generate the pole information
        atypes = self.chromosomes.GeneratePoleInformation(microtubules)

        return atypes

    # How many endon attachmenst does each chromosome have?
    def GenerateEndOnAttachments(self, microtubules):
        endon = self.chromosomes.GenerateEndOnAttachments(microtubules)

        return endon

    # How many of the AF are bound?
    def GenerateNBound(self):
        nbound = self.chromosomes.GenerateNBound()

        return nbound

    # What is the distance to the first spb?
    def GetKCDistance(self, spbs):
        rspb = spbs[0].r

        distances = []
        for kc in self.chromosomes.kinetochores:
            distances += [np.linalg.norm(rspb - kc.r)]

        return distances

    # Are we doing anaphase or not?
    def GetAnaphase(self):
        if 'Anaphase' in self.chromo_yaml['chromosomes']['properties']:
            if self.chromo_yaml['chromosomes']['properties']['Anaphase'] == True:
                return True
        return False

    # Get the attachment lifetime calc at present
    def GetAttachmentLifetimes(self):
        return self.chromosomes.kmt_lifetimes

##########################################
if __name__ == "__main__":
    t = ReadPositSpindle(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4])
    t.LoadPosit()
    t.ReadFramePosit()
    t.PrintFrame()
    print "TEST ONLY!!!!"



