#!/usr/bin/env python
# In case of poor (Sh***y) commenting contact adam.lamson@colorado.edu
# YOLO edelmaie@colorado.edu (too)
# Basic
import sys, os, pdb
import gc
## Analysis
import numpy as np
import yaml

from operator import attrgetter

from scipy import special
import scipy.misc

from read_posit_base import ReadPositBase

from quaternion import quaternion_between_vectors
from quaternion import axisangle_from_quaternion 
from quaternion import rodrigues_axisangle
from quaternion import quaternion_multiply
from quaternion import rotation_matrix_from_quaternion

# import pandas as pd
# import matplotlib.pyplot as plt
# import matplotlib as mpl
# from math import *

'''
Name: read_posit_forces.py
Description:
Input:
Output:
'''

#Class definition
class ReadPositForces(ReadPositBase):
    def __init__(self, seed_path, posit_name,
                 default_file='default.yaml', equil_file='equil.yaml'):
        ReadPositBase.__init__(self, seed_path, posit_name, default_file, equil_file)
        self.is_active = False # Set an active flag for historical compatibility

    def LoadPosit(self, nchromosomes=3):
        if os.path.isfile(self.posit_path):
            self.f_posit = open(self.posit_path)
            self.is_active = True
        else:
            self.is_active = False
            return
        self.ReadPosHeader(nchromosomes)

    def UnloadPosit(self):
        self.f_posit.close()

    def ReadPosHeader(self, nchromosomes):
        if not self.is_active:
            return
        # Therm file is now in plaintext, with a header describing what is
        # going on
        line = self.f_posit.readline().rstrip()
        # Find the start of the header
        if line == "HEADERINFO":
            # The next lines are always specified
            line = self.f_posit.readline().rstrip()
            self.ndim = np.int(line.split()[1])
            line = self.f_posit.readline().rstrip()
            self.ntypes = np.int(line.split()[1])
            line = self.f_posit.readline().rstrip()
            self.nanchors = np.int(line.split()[1])

            # FIXME: Hardcoded for 3 chromosomes
            self.nchromosomes = nchromosomes
            print "running on {} chromosomes".format(self.nchromosomes)

            # Now come all the special ptentials that we have enabled
            line = self.f_posit.readline().rstrip()
            while line != "ENDHEADERINFOEND":
                print "should not be here!"

        line = self.f_posit.readline().rstrip() # This is really just a header to easily grab the information
        self.cur_frame = -1

        # Create the structure to read into:
        # Create the pole information
        self.poles = {}
        for ipole in xrange(self.nanchors):
            self.poles[ipole] = {}
            # Create the xlink poles
            self.poles[ipole]['xlinks'] = {}
            for itype in xrange(self.ntypes):
                self.poles[ipole]['xlinks'][itype] = np.array([0.0, 0.0, 0.0])

            # The AF by pole
            self.poles[ipole]['af'] = np.array([0.0, 0.0, 0.0])

        # Interchromosome stuff
        self.poles['chromosomes'] = {}
        for ic in xrange(self.nchromosomes):
            self.poles['chromosomes'][ic] = np.array([0.0, 0.0, 0.0])
            

    def ReadFramePosit(self):
        if not self.is_active:
            return
        # The posit file is now plaintext, so readoff this frame
        line = self.f_posit.readline().rstrip()
        linesplit = line.split()

        # The first sets of values are the pole information for the xlink forces
        # [ipole] x [itype] x [idim]
        for ipole in xrange(self.nanchors):
            for itype in xrange(self.ntypes):
                for idim in xrange(self.ndim):
                    val = linesplit.pop(0) # pop of the front
                    self.poles[ipole]['xlinks'][itype][idim] = val

        # Now the AFs
        for ipole in xrange(self.nanchors):
            for idim in xrange(self.ndim):
                val = linesplit.pop(0)
                self.poles[ipole]['af'][idim] = val

        # Finally the 3 chromsomes
        for ic in xrange(self.nchromosomes):
            for idim in xrange(self.ndim):
                val = linesplit.pop(0)
                self.poles['chromosomes'][ic][idim] = val

        self.cur_frame += 1

    ### Print functionality
    def __repr__(self):
        retrstring = "ReadPositThermo\n"
        retrstring += "   ndim: {}\n".format(self.ndim)
        retrstring += "   ntypes: {}\n".format(self.ntypes)
        retrstring += "   nanchors: {}\n".format(self.nanchors)

        return retrstring

    def PrintFrame(self):
        print "****************"
        print "Frame: {}".format(self.cur_frame)
        # Print out current information
        for ipole in xrange(self.nanchors):
            print "Pole{}".format(ipole)
            for itype in xrange(self.ntypes):
                print "  Xlink{} = {}".format(itype, self.poles[ipole]['xlinks'][itype])
            print "  AF = {}".format(self.poles[ipole]['af'])
        for ic in xrange(self.nchromosomes):
            print "Chromosome{} = {}".format(ic, self.poles['chromosomes'][ic])

    # Generate the spindle forces at this timestep
    def GenerateSpindleForces(self, spindlevector, uc):
        # Generate the parallel and perpendicular forces on each SPB
        # with regards to the main spindle vector
        shat = spindlevector / np.linalg.norm(spindlevector)

        pole_return = {}

        # Do both of the poles, the chromosome information is shared actually
        for ipole in xrange(self.nanchors):
            # Get the xlink contributions along the spindle axis
            # also, subtype this for later use (we want this information)
            xlink_by_type = []
            xlink_total = np.array([0.0, 0.0, 0.0])
            for itype in xrange(self.ntypes):
                xlink_total += self.poles[ipole]['xlinks'][itype]
                xlink_by_type += [self.poles[ipole]['xlinks'][itype]]
            
            # Turn the subtype into an array
            xlink_by_type = np.array(xlink_by_type)

            # Now get the AF on pole
            af_total = self.poles[ipole]['af']

            # Use the dot product to figure out how much of the forces lies along the spindle axis
            xlink_axis = np.dot(shat, xlink_total)
            xlink_axis_subtype = []
            for itype in xrange(self.ntypes):
                xlink_axis_subtype += [np.dot(shat, xlink_by_type[itype])]
            xlink_axis_subtype = np.array(xlink_axis_subtype)

            # And the AFs
            af_axis = np.dot(shat, af_total)

            # Grab the norm of each too, that might be interesting
            xlink_mag = np.linalg.norm(xlink_total)
            xlink_mag_subtype = []
            for itype in xrange(self.ntypes):
                xlink_mag_subtype += [np.linalg.norm(xlink_by_type[itype])]
            xlink_mag_subtype = np.array(xlink_mag_subtype)

            # And the AF
            af_mag = np.linalg.norm(af_total)

            # Grab the total chromosome involvement too
            # Each one individually, because of the ambiguitiy on which pole they
            # are attached to
            chromosome_mag = 0.0
            for ic in xrange(self.nchromosomes):
                chromosome_mag += np.linalg.norm(self.poles['chromosomes'][ic])

            # Construct a custom return statement
            pole_return[ipole] = {}
            pole_return[ipole]['xlink_mag'] = xlink_mag * uc['pN'][1]
            pole_return[ipole]['xlink_mag_subtype'] = xlink_mag_subtype * uc['pN'][1]
            pole_return[ipole]['xlink_axis'] = xlink_axis * uc['pN'][1]
            pole_return[ipole]['xlink_axis_subtype'] = xlink_axis_subtype * uc['pN'][1]
            pole_return[ipole]['af_mag'] = af_mag * uc['pN'][1]
            pole_return[ipole]['af_axis'] = af_axis * uc['pN'][1]
            pole_return[ipole]['chromosome_mag'] = chromosome_mag * uc['pN'][1]

        return pole_return

##########################################
if __name__ == "__main__":
    t = ReadPositForces(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4])
    t.LoadPosit()
    print "{}".format(t)
    t.ReadFramePosit()
    t.PrintFrame()
    print "TEST ONLY!!!!"




