#!/usr/bin/env python
# In case of poor (Sh***y) commenting contact adam.lamson@colorado.edu
# Basic
import sys, os, pdb
import gc
## Analysis
# import pandas as pd
import numpy as np
import yaml

from scipy import special
import scipy.misc

# sys.path.append(os.path.join(os.path.dirname(__file__), '..', 'Lib'))
from read_posit_base import ReadPositBase
from microtubule import Microtubule
from spindle_pole_body import SpindlePoleBody
from gaussian_imaging import GaussianLine2D
from gaussian_imaging import GaussianLine3D

import matplotlib.pyplot as plt
import matplotlib as mpl
# mpl.use("Agg")
import matplotlib.animation as animation

#import line_profiler

# from matplotlib.animation import FuncAnimation


# from antiparallel_overlap import antiparallel_overlap

'''
Name:
Description:
Input:
Output:
'''

# def periodic_boundary_conditions(n_periodic, h, r):
#     s = [0]*n_periodic
#     for i in xrange(n_periodic):
#         for j in xrange(n_periodic):
#             s[i] = np.divide(1.0,h[i,j])*r[j]
#         s[
#Class definition
class ReadPositSphero(ReadPositBase):
    def __init__(self, seed_path, posit_name,
                 default_file='default.yaml', equil_file='equil.yaml'):
        ReadPositBase.__init__(self, seed_path, posit_name, default_file, equil_file)
        self.microtubules = []

        self.headerdt = np.dtype([
            ('ndim', np.int32),
            ('nspheros', np.int32)
            ])

    def LoadPosit(self):
        ReadPositBase.LoadPosit(self)
        self.spheros = [Microtubule(i) for i in xrange(self.nspheros)]

    def ReadPosHeader(self):
        header = ReadPositBase.ReadPosHeader(self, self.headerdt)
        self.ndim = abs(header['ndim'])
        self.nspheros = header['nspheros']
        # Make configsize for CountFrames method
        self.configsize = (self.ndim*self.ndim + self.nspheros*2*self.ndim)*4
        # Make frame data type for ReadFramePosit
        self.framedt = np.dtype([
            # ('ndim', np.int32),
            # ('nspheros', np.int32),
            ('h', 'f4', (self.ndim, self.ndim)),
            ('rsite', 'f4', (2*self.nspheros, self.ndim)),
            # ('vsite', 'f4', (2*self.nspheros, self.ndim)),
            ])

    def ReadFramePosit(self):
        # TODO Only works for square unit cells and systems with where rod lengths < .5*side length
        frame = ReadPositBase.ReadFramePosit(self)
        self.h = frame['h']
        self.rsite = frame['rsite']

        n_periodic = self.CheckDefaultThenEquil('n_periodic', val=self.ndim)
        length = self.h[0,0] # get side length

        for rod in self.spheros:
            i = rod.idx
            vmt = self.rsite[2*i+1] - self.rsite[2*i]
            lmt = np.linalg.norm(vmt)
            if lmt > (length*.5): # Handle periodic boundary condtions
                for j in xrange(n_periodic):
                    if vmt[j]>(length*.5): vmt[j] -= length 
                    elif vmt[j]<(length*-.5): vmt[j] += length 
                lmt = np.linalg.norm(vmt)
            umt = np.divide(vmt,lmt)
            rmt = self.rsite[2*i] + 0.5*vmt
            rod.r = rmt
            rod.u = umt
            rod.v = vmt
            rod.l = lmt
        self.cur_frame += 1

        return

    def PrintSpheros(self):
        for rod in self.spheros:
            print "   - ", rod
        print ""

    def DrawSpheros(self, ax):
        for rod in self.spheros:
            rod.Draw2DMT(ax)




##########################################

#@profile
def main(argv):
    print "--- Testing read_posit_sphero.py ---"

    seed_path = argv[1]
    posit_name = argv[2]
    rp_sphero = ReadPositSphero(seed_path, posit_name)
    rp_sphero.LoadPosit()
    fig = plt.figure()
    ax = plt.axes(xlim=(-50, 50), ylim=(-50,50), aspect='equal')

    writer = animation.FFMpegWriter(fps=30)

    print "Created writer"
    # def update(i):
        # rp_sphero.ReadFramePosit()
        # rp_sphero.DrawSpheros(ax)
        # return ax,

    # anima = anb(fig, update, frames, rp_sphero.nframes, interval=20, blit=True)


    

    dpi = fig.get_dpi()

    with writer.saving(fig, "sphero_writer.mp4", dpi=dpi):
        # print "saving to writer"
        print "rp_sphero.nframes = ", rp_sphero.nframes
        for n in xrange(rp_sphero.nframes-1):
            rp_sphero.ReadFramePosit()
            rp_sphero.DrawSpheros(ax)
            print " --Frame: ", n
            writer.grab_frame()
            ax.clear()

if __name__ == "__main__":
    main(sys.argv)
        







