#!/usr/bin/env python
# In case of poor (Sh***y) commenting contact adam.lamson@colorado.edu
# Basic
import sys, os, pdb
## Analysis
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
from math import *
from path_funcs import Get_dir_names
from sim_base import SimBase
from seed_base import SeedBase

'''
Name: run_base.py
Description:
Input:
Output:
'''

class RunBase(object):
    def __init__(self, opts, simdir_path="simulations", 
            simType=SimBase, seedType=SeedBase):
        self.opts = opts
        self.run_path = os.path.abspath(opts.workdir)
        self.run_name = self.run_path.split('/')[-1]
        self.simdir_path = os.path.join(self.run_path, simdir_path)

        # Objects to be filled later
        self.sims = []
        self.p_names = []
        self.p_range = {}

        self.simType = simType
        self.seedType = seedType

        if ( self.opts.analyze or 
             self.opts.graph or 
             self.opts.write or 
             self.opts.movie_comp ):
            self.CollectSims()

        # flags
        self.analyze_flag = False

    # Creates sim objects and stores them in a list

    def CollectSims(self):
        self.sims = [self.simType(os.path.join(self.simdir_path, sim_path), self.opts) 
                for sim_path in Get_dir_names(self.simdir_path)]
        empty_sims = True # Sometimes sims are empty so its necessary to make sure you get
                          # data from a full one.
        for sim in self.sims:
            if len(sim.seeds) != 0:
                empty_sims = False
                self.p_names = list(sim.params.keys())
                break
        if empty_sims: raise RuntimeError("Could not find any simulations with valid seeds.")
        # Get range of parameter values
        for pn in self.p_names:
            val_list = []
            for sim in self.sims: 
                if len(sim.seeds) == 0: continue # In case a sim is empty of seeds
                val_list += [float(sim.params[pn])]
            self.p_range[pn] = (min(val_list), max(val_list))

    def AnalyzeSims(self):
        if not self.analyze_flag:
            for sim in self.sims: sim.Analyze()
            self.analyze_flag = True

    def WriteSimData(self):
        for sim in self.sims: sim.WriteData()

    def GraphSims(self):
        for sim in self.sims:
            print "--- Graphing sim {} ---".format(sim.name)
            sim.GraphSimulation()

    def GraphRun(self):
        raise NotImplementedError("GraphRun")

    def ReadSims(self, analysis_files):
        for sim in self.sims: 
            sim.Read(analysis_files, header=0, index_col=0)

    def PrintRunData(self):
        for sim in self.sims: sim.PrintSimData()


    __CollectSims = CollectSims
    __GraphSims = GraphSims

##########################################
if __name__ == "__main__":
    print "Not implemented yet"




