#!/usr/bin/env python
## Basic
import sys, os, pdb
import re
## Analysis
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
from math import *
from base_funcs import *

'''
Name:seed_base.py
Description: Base code to collect and hold all data from one seed
Input: Path to the seed file, (optional: list of data files to be analyzed)
Output: Can make graphs if given an axis object from something
'''

class SeedBase(object):
    def __init__(self, path, opts=None):
        self.opts = opts
        self.path = os.path.abspath(path)
        self.name = self.path.split('/')[-1]
        self.label, self.seed_num = self.MakeSeedLabel()
        self.dat_dict = {}
        # if dat_file_list:
            # self.MakeDataDict(dat_file_list)

    def MakeDataDict(self, dat_file_list='',
                     header=0, index_col=None):
        if not dat_file_list:
            print "No data list given."

        for dl in dat_file_list:
            data_array = self.GetDataArray(dl,
                                           header=header,
                                           index_col=index_col)
            if isinstance(data_array, pd.DataFrame):
                self.dat_dict[dl] = data_array
            else:
                return False

    def GetDataArray(self, dat_file, header=0, index_col=None):
        dat_path = os.path.join(self.path, dat_file)
        if os.path.exists(dat_path):
            data = pd.read_csv( dat_path, delimiter=' ',
                                header=header, index_col=index_col)
            return data
        else:
            print "No file named {} in seed directory {}.".format(dat_file, self.path)
            return False

    def MakeSeedLabel(self):
        snum = re.findall("\d*\.?\d+", self.name)
        try:
            slabel = r's $=$ {}'.format(snum[-1])
            return slabel, int(snum[-1])
        except:
            print "Could not make seed label. Using name of seed directory."
            return self.name, 0

    def WriteAllData(self):
        VirtualMethodError("WriteAllData", self)

    def PrintData(self):
        print "    Data Dict ({}): ".format(self.name),
        print self.dat_dict


##########################################
if __name__ == "__main__":
    print "Not implemented yet"




