#!/usr/bin/env python
# In case of poor (Sh**y) commenting contact adam.lamson@colorado
# Basic
import sys, os, pdb
import ast
from subprocess import call
import re
## Analysis
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
from path_funcs import Get_dir_names
from seed_base import SeedBase
from math import *
from base_funcs import *

'''
Name: sim_base.py
Description: Base class that holds multiple seeds that have the same
             parameters aka a sim.
Input:
Output:
'''

#Class definition
class SimBase(object):
    def __init__(self, sim_path, opts, seedType = SeedBase):
        self.sim_path = os.path.abspath(sim_path)
        self.name= self.sim_path.split('/')[-1]
        self.title = self.MakeSimTitle(self, sim_path)
        self.params = self.MakeSimParamDict(self, sim_path)
        self.opts = opts

        self.seedType = seedType
        self.seeds = []

        self.CollectSeeds(seedType)

    def CollectSeeds(self, seedType):
        seed_pattern = re.compile("s\d+")

        print("sim_path = {}".format(self.sim_path))

        # Make list of seeds of type seedType
        self.seeds = [seedType(os.path.join(self.sim_path,sd), self.opts) 
                for sd in  Get_dir_names(self.sim_path) if seed_pattern.match(sd)] 
        self.seeds.sort(key=lambda sd: sd.seed_num)

    def WriteAllData(self):
        if not self.opts.datadir:
            self.opts.datadir = create_datadir(self.opts.workdir)

        print self.title
        for sd in self.seeds: sd.WriteAllData()

    @staticmethod
    def MakeSimParamDict(self, sim_path, uc=''):
        params = {}
        sim_name = sim_path.split('/')[-1]
        # Check for an MD5 hash to make sure we don't bomb
        is_hash = re.findall(r"([a-fA-F\d]{32})", sim_name)
        if len(is_hash) > 0:
            return params
        p_name = re.findall("[a-zA-Z]+", sim_name)
        p_value = re.findall("\d*\.?\d+", sim_name)

        ## CJE stuff
        while 'e' in p_name:
            p_name.remove('e')
        match_number = re.compile('-?\ *[0-9]+\.?[0-9]*(?:[Ee]\ *-?\ *[0-9]+)?')
        p_value2 = re.findall(match_number, sim_name)

        #print "sim_name: {}".format(sim_name)
        #print "p_name: {}".format(p_name)
        #print "p_value: {}".format(p_value)
        #print "p_value2: {}".format(p_value2)

        for p, v in zip(p_name, p_value2):
            if uc:
                params[p] = ast.literal_eval(v)*uc[p][1]
            else:
                params[p] = ast.literal_eval(v)

        return params

    @staticmethod
    def MakeSimTitle(self, sim_path, uc=''):
        name = sim_path.split('/')[-1]
        # Check for an MD5 hash to make sure we don't bomb
        is_hash = re.findall(r"([a-fA-F\d]{32})", name)
        if len(is_hash) > 0:
            label = r"hash {}".format(is_hash)
            return label
        param = re.findall("[a-zA-Z]+", name)
        p_value = re.findall("\d*\.?\d+", name)

        ## CJE Stuff for scientific notation
        while 'e' in param:
            param.remove('e')
        match_number = re.compile('-?\ *[0-9]+\.?[0-9]*(?:[Ee]\ *-?\ *[0-9]+)?')
        p_value2 = re.findall(match_number, name)

        #print "pvalue2: {}".format(p_value2)

        label = r''
        slabel = r'{} $=$ {}{}, '
        for p, v in zip(param, p_value2):
            if uc:
                label += slabel.format(p, 
                        str(ast.literal_eval(v)*uc[p][1]), uc[p][0]) 
            else:
                label += slabel.format(p, 
                        str(ast.literal_eval(v)), '') 
        return label[:-2]

    def Read(self, data_file_list='', header=None, index_col=None):
        for sd in self.seeds: 
            sd.MakeDataDict(data_file_list, 
                            header=header, 
                            index_col=index_col)
        print "    Sim read ({}) ".format(self.name)

    def WriteData(self):
        for sd in self.seeds: sd.WriteAllData()

    def PrintSimData(self):
        for sd in self.seeds: sd.PrintData()

    def DelDataArray(self):
        raise NotImplementedError("DelDataArray")

    def GraphSimulation(self, png_name):
        raise VirtualMethodError("GraphSimulation")

    def Analyze(self, raw_dat_list=''):
        raise VirtualMethodError("Analyze", self)

    def GetParamNames(self):
        return list(self.params.keys())


##########################################
if __name__ == "__main__":
    print "Not implemented yet"




