#!/usr/bin/env python
# In case of poor (Sh***y) commenting contact adam.lamson@colorado.edu
# Basic
import sys, os, pdb
## Analysis
# import pandas as pd
import numpy as np
from numpy import dot
# import matplotlib.pyplot as plt
# import matplotlib as mpl
from math import *

'''
Name: antiparallel_overlap.py
Description: Determine if two microtubules overlab by a given amount.
             Ported from newagebob/src/antiparallel_overlap.cpp
Input:

Output: Distance that MTs are overlapped
'''

def NINT(x): 
    if x < 0.0: return int(x-0.5)
    else: int(x + 0.5)

def antiparallel_overlap(r1, u1, len1, r2, u2, len2, 
                         s1=np.zeros((3)), s2=np.zeros((3)), 
                         ndim=3, nperiodic=0, h=np.ones((3,3)), 
                         well_diam=1.6):
    # pdb.set_trace()
    # Make sure types match
    if not isinstance(r1, np.ndarray): r1 = np.array(r1)
    if not isinstance(s1, np.ndarray): s1 = np.array(s1)
    if not isinstance(u1, np.ndarray): u1 = np.array(u1)
    if not isinstance(r2, np.ndarray): r2 = np.array(r2)
    if not isinstance(s2, np.ndarray): s2 = np.array(s2)
    if not isinstance(u2, np.ndarray): u2 = np.array(u2)
    if not isinstance(h, np.ndarray): h = np.ndarray(h)
    
    u1 = np.divide(u1, np.linalg.norm(u1))
    u2 = np.divide(u2, np.linalg.norm(u2))

    half_len1 = len1*.5
    half_len2 = len2*.5
    well_diam2 = well_diam**2
    ds = np.zeros((3))
    dr = np.zeros((3))

    # Handle periodic boundary conditions
    if nperiodic > 0:
        for i in xrange(nperiodic):
            ds[i] = s2[i] - s1[i]
            ds[i] -= float(NINT(ds[i]))

        # Incase the unit cell is not square
        for i in xrange(nperiodic):
            dr[i] = 0.0
            for j in xrange(nperiodic):                
                dr[i] += h[i][j] * ds[j]

    # Get displacement vector between mts
    for i in xrange(nperiodic, ndim):
        dr[i] = r2[i] - r1[i] 

    # Get distance squared between mts
    dr2 = dot(dr,dr)

    # If mts are too far away then return 0
    if dr2 >= ((half_len1 + half_len2 + well_diam)**2): return .0

    # Check to make sure the dot product of the directors are negative
    if dot(u1, u2) >= 0.0: return .0
    else: u2_neg = -1.0*u2
        # u2_neg = [-x for x in u2]

    d = dot(u1, u2_neg)
    alpha = 1.0 - (d**2)
    beta = np.sqrt(alpha)

    # Case where MTs are not parallel
    if alpha > (10.0**(-7)):
        # Find closest approach of infinite long lines
        b = dot(dr, u2_neg)
        c = dot(dr, u1)
        lambda_0 = (c-b*d)/alpha
        mu_0 = (-b+c*d)/alpha

        # Compute minimum distance between lines
        if ndim == 3:
            rmin = [dr[i] - (lambda_0*u1[i]) + (mu_0*u2_neg[i]) for i in xrange(ndim) ]
            rmin2 = dot(rmin, rmin)

        # If the minimum distance exceeds interaction range,
        # the lines don't interact.
        if rmin2 >= well_diam2:
            # print "Minimum distance exceeds interaction range"
            return 0.0

        # Calculate interaction parameter.
        a2 = well_diam2 - rmin2
        a = np.sqrt(a2)

        # Transform to parameters defined with respect to 'intersection' of
        # carrier lines (gamma and delta) gamma_0 and delta_0 are the centers
        # of the line segments in terms of these new parameters.  In terms of
        # gamma and delta, the integration region is a rectangle, and the
        # interaction energy is proportional to the overlap area of this
        # rectangle and the ellipse defined by gamma^2 + delta^2 - 2 * gamma *
        # delta * d = r_ellipse^2.
        gamma_0 = -lambda_0
        delta_0 = -mu_0

        # /* Calculate coordinates of extremal points of ellipse. */
        fact1 = a / beta
        fact2 = fact1 * d
        gamma_A = -fact1
        delta_A = -fact2
        gamma_B = fact1
        delta_B = fact2
        delta_C = -fact1
        delta_D = fact1

        # /* Determine upper and lower limits of bounding rectangle. */
        gamma_l = max(gamma_0 - half_len1, gamma_A)
        gamma_u = min(gamma_0 + half_len1, gamma_B)
        delta_l = max(delta_0 - half_len2, delta_C)
        delta_u = min(delta_0 + half_len2, delta_D)

        # /* If the ellipse and rectangle don't intersect, the lines don't interact. */
        if (gamma_l >= gamma_u or delta_l >= delta_u):
            # print "Ellipse and rectangle don't intersect"
            return 0.0

        # /* Calculate intersection points of horizontal sides of rectangle with ellipse. */
        fact3 = np.sqrt(abs(a2 - (delta_l**2) * alpha))
        fact4 = np.sqrt(abs(a2 - (delta_u**2) * alpha))
        gamma_1 = delta_l * d - fact3
        gamma_2 = delta_l * d + fact3
        gamma_3 = delta_u * d - fact4
        gamma_4 = delta_u * d + fact4

        # Now determine limits of integration.
        if (delta_l > delta_A):
            gamma_a = max(gamma_1, gamma_l)
        else:
            if (delta_u > delta_A):
                gamma_a = max(gamma_A, gamma_l)
            else:
                gamma_a = max(gamma_3, gamma_l)

        if (delta_u <= delta_B):
            gamma_b = min(gamma_4, gamma_u)
        else:
            if (delta_l <= delta_B):
                gamma_b = min(gamma_B, gamma_u)
            else:
                gamma_b = min(gamma_2, gamma_u)

        # /* Calculate the length of the overlap area. */
        if(gamma_b > gamma_a):
            u = gamma_b - gamma_a
        else:
            u = 0.0


    # /* The case of nearly parallel lines needs to be handled separately. */
    else:
        # /* Resolve pair separation vector into parallel and perpendicular components. */
        z = dot(dr, u1)
        z2 = z**2
        rho2 = dr2 - z2

        # /* If the perpendicular distance exceeds the interaction range, the lines don't interact. */
        if (rho2 >= well_diam2):
            # print "perpendicular distance exceeds the interaction range"
            return 0.0

        # /* Calculate interaction parameter. */
        a2 = well_diam2 - rho2
        a = np.sqrt(a2)

        lambda_1 = min(half_len1, max(-half_len1, -half_len2 + z - a))
        lambda_2 = min(half_len1, max(-half_len1, half_len2 + z - a))

        # /* Calculate potential energy of two interacting square well lines. */
        u = lambda_2 - lambda_1

    # /* Return potential energy of pair of interacting lines. */
    # if u >= 0: pdb.set_trace()
    # pdb.set_trace()
    return u



##########################################
if __name__ == "__main__":
    print "Not implemented yet"




