#!/usr/bin/env python
# In case of poor (Sh***y) commenting contact adam.lamson@colorado.edu
# Basic
import sys, os, pdb
## Analysis
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
from math import *

prog_path=os.path.realpath(__file__)
sys.path.append(os.path.join(os.path.dirname(prog_path), '..', 'Lib'))
from graph_lib import *
from sim_graph_funcs import *
from run_graph_funcs import graph_run_scatter_binomial_error, graph_run_scatter_error
from bin_functions import *
from spindle_unit_dict import *
from stylelib.ase1_styles import ase1_runs_stl

'''
Name: ase1_oneoffs.py
Description: Graphing functions to make figures for ase1 only paper
'''

uc = SpindleUnitDict()

def PA_all_log_break(data_path, title='', *args):
    if title:
        save_path = os.path.join(os.getcwd(),"{}.pdf".format(title))
    else:
        save_path = os.path.join(os.getcwd(),"PA_all.pdf")
    # Data collection
    df = pd.read_csv(data_path, delimiter=' ', header=0)
    param = 'pa'
    p_vals = df[param].astype(uc[param][2])*uc[param][1]
    # Graphing 
    xticks = np.unique(p_vals)
    l, m, n = (1.0, float(len(xticks)-2), 1.0)
    with plt.style.context(ase1_runs_stl):
        f, axarr = plt.subplots(1, 3, sharey=True, figsize=(10,6), gridspec_kw = {'width_ratios':[l,m,n]})
        pmin, pmax = (np.amin(df[param]), np.amax(df[param])) # Max and min pvals for break
        p_vals_zero = df.loc[df[param]==[pmin], param].astype(uc[param][2])*uc[param][1]
        p_vals_max = df.loc[df[param]==[pmax], param].astype(uc[param][2])*uc[param][1]
        # p_vals_mid = df.loc[df[param]!=[pmin] and df[param]!=[pmax], param].astype(uc[param][2])*uc[param][1]
        p_vals_mid = df[~df[param].isin([pmin, pmax])][param].astype(uc[param][2])*uc[param][1]
        graph_run_scatter_binomial_error(axarr[0], [xticks[0]], p_vals_zero, df[df[param].isin([pmin])]['succ'])
        graph_run_scatter_binomial_error(axarr[1], xticks[1:-1], p_vals_mid, df[~df[param].isin([pmin, pmax])]['succ'], xlog=True)
        graph_run_scatter_binomial_error(axarr[2], [xticks[-1]], p_vals_max, df.loc[df[param]==[pmax], 'succ'])
        # Make breaks in graphs
        axarr[0].spines['right'].set_visible(False)
        axarr[1].spines['left'].set_visible(False)
        axarr[1].spines['right'].set_visible(False)
        axarr[2].spines['left'].set_visible(False)
        # axarr[0].yaxis.tick_left()
        axarr[0].tick_params(labelright='off')
        axarr[1].tick_params(left='off')
        axarr[2].tick_params(labelleft='off')
        axarr[2].yaxis.tick_right()
        plt.subplots_adjust(wspace=.05, bottom=.16) # Bring graphs closer together

        # axarr[1].set_xticks(np.unique(p_vals_mid))
        # Make break marks
        d = .01 # how big to make the diagonal lines in axes coordinates
    # arguments to pass plot, just so we don't keep repeating them
        # TODO make this a general function
        kwargs = dict(transform=axarr[0].transAxes, color='k', clip_on=False)
        olm = (l+m)/l; oml = (m+l)/m; omn = (n+m)/m; onm = (n+m)/n 
        axarr[0].plot((1-d*olm,1+d*olm),(-d,d), linewidth=1, **kwargs) # bottom-left diagonal
        axarr[0].plot((1-d*olm,1+d*olm),(1-d,1+d), linewidth=1, **kwargs) # top-left diagonal
        kwargs.update(transform=axarr[1].transAxes) # switch to the bottom axes
        axarr[1].plot((-d*oml,d*oml),(-d,d), linewidth=1, **kwargs) # bottom-left diagonal
        axarr[1].plot((-d*oml,d*oml),(1-d,1+d), linewidth=1, **kwargs) # top-left diagonal
        axarr[1].plot((1-d*omn,1+d*omn),(-d,d), linewidth=1, **kwargs) # bottom-left diagonal
        axarr[1].plot((1-d*omn,1+d*omn),(1-d,1+d), linewidth=1,**kwargs) # top-left diagonal
        kwargs.update(transform=axarr[2].transAxes) # switch to the bottom axes
        axarr[2].plot((-d*onm,d*onm),(-d,d), linewidth=1, **kwargs) # bottom-right diagonal
        axarr[2].plot((-d*onm,d*onm),(1-d,1+d), linewidth=1,**kwargs) # top-right diagonal
        # Make plot pretty and save it
        axarr[0].set_ylim(bottom=0)
        axarr[0].set_ylabel(r'Bipolar Spindle Frequency ($\%$)')
        axarr[1].set_xlabel('Parallel-to-Antiparallel \n Binding Ratio')
        # ModifyXLabel(axarr[1], param)
        # axarr[1].set_label(r'Bipolar Spindle Frequency ($\%$)')
        if title: plt.suptitle(title)
        plt.savefig(save_path)
        plt.show()

    return

def dbD_all_log_break(data_path, title='', *args):
    """ Function that graphs the doubly bound diffusion of xlinks on a xlog scale with a break at zero.
        Inputs: data_path = path to pandas data file
                title     = title of graph
        Outputs: returns nothing, pdf is created for image
    """
    if title:
        save_path = os.path.join(os.getcwd(),"{}.pdf".format(title))
    else:
        save_path = os.path.join(os.getcwd(),"dbD_log_all.pdf")
    # Get data for graphing
    df = pd.read_csv(data_path, delimiter=' ', header=0) # Data frame containing success rates
    param = 'dbD' # shortcut name for doubly bound diffusion
    p_vals = df[param].astype(uc[param][2])*uc[param][1] # All parameter values
    xticks = np.unique(p_vals) # unique p_vals for marking graph
    pmin = np.amin(xticks)
    # Make figure and axes, to do the line break you need to create two mpl axis objects and then 
    #  make it look like they are joined together
    n = 1; m = len(xticks)-1 # ratio points for the two graphs
    with plt.style.context(ase1_runs_stl):
        fig, (ax, ax2) = plt.subplots(1, 2, sharey=True, gridspec_kw = {'width_ratios':[n,m]}, figsize=(8,6))
        # A list of p_vals which should all be zero 
        p_vals_zero = df.loc[df[param]==[pmin], param].astype(uc[param][2])*uc[param][1]
        p_vals_rest = df[~df[param].isin([pmin])][param].astype(uc[param][2])*uc[param][1]
        # Graphing, first just the 0 point on a linear scale and then all other values on a log scale
        graph_run_scatter_binomial_error(ax, [pmin], p_vals_zero, df.loc[df[param]==[pmin], 'succ'])
        graph_run_scatter_binomial_error(ax2, xticks[1:], p_vals_rest, df[~df[param].isin([pmin])]['succ'], xlog=True)
        # Remove borders to make it look like the two graphs are 1
        ax.spines['right'].set_visible(False)
        ax2.spines['left'].set_visible(False)
        ax.yaxis.tick_left()
        # ax.tick_params(labelright='off')
        ax.tick_params(labeltop='off')
        ax2.yaxis.tick_right()
        ax2.tick_params(right='off', labelright='off')
        plt.subplots_adjust(wspace=.05, bottom=.16, top=0.95) # Bring graphs closer together

        # Make break marks
        d = .015 # how big to make the diagonal lines in axes coordinates
        # arguments to pass plot, just so we don't keep repeating them
        kwargs = dict(transform=ax.transAxes, color='k', clip_on=False)
        on = (n+m)/n; om = (n+m)/m;
        ax.plot((1-d*on,1+d*on),(-d,d), linewidth=1, **kwargs) # bottom-left diagonal
        ax.plot((1-d*on,1+d*on),(1-d,1+d), linewidth=1, **kwargs) # top-left diagonal
        kwargs.update(transform=ax2.transAxes) # switch to the bottom axes
        ax2.plot((-d*om,d*om),(-d,d), linewidth=1, **kwargs) # bottom-right diagonal
        ax2.plot((-d*om,d*om),(1-d,1+d), linewidth=1, **kwargs) # top-right diagonal

        ax.set_ylabel(r'Bipolar Spindle Frequency ($\%$)')
        ax.set_ylim(bottom=0)
        ModifyXLabel(ax2, param)
        if title: plt.suptitle(title)
        plt.savefig(save_path)
        plt.show()
    return

def double_dat_succ(data_path1, data_path2, param, label1='1', label2='2', title='', *args):
    """ Function that graphs the success rate using two .dat files. Data sets are distinguished by colors in graph.
        Inputs: data_path1 = path to first pandas data file
                data_path2 = path to second pandas data file
                param      = parameter that will be graphed
                label1     = label of legend for first data set
                label2     = label of legend for second data set
                title      = title of graph
        Outputs: returns nothing, pdf is created for image
    """
    if title:
        save_path = os.path.join(os.getcwd(),"{}.pdf".format(title))
    else:
        save_path = os.path.join(os.getcwd(),"{}_double_set.pdf".format(param))
    df1 = pd.read_csv(data_path1, delimiter=' ', header=0)
    df2 = pd.read_csv(data_path2, delimiter=' ', header=0)
    p_vals1 = df1[param].astype(uc[param][2])*uc[param][1]
    p_vals2 = df2[param].astype(uc[param][2])*uc[param][1]
    xticks1 = np.unique(p_vals1)
    xticks2 = np.unique(p_vals2)
    with plt.style.context(ase1_runs_stl):
        f, ax = plt.subplots(figsize=(10,6))
        graph_run_scatter_binomial_error(ax, xticks1, p_vals1, df1['succ'], color='r', label=label1)
        graph_run_scatter_binomial_error(ax, xticks2, p_vals2, df2['succ'], color='b', label=label2)
        # plt.subplots_adjust(right=.72)
        # ax.legend(loc='center left', bbox_to_anchor=(1.0, .5))
        ax.legend()
        ax.set_ylabel(r'Bipolar Spindle Frequency ($\%$)')
        ModifyXLabel(ax, param)
        if title: plt.suptitle(title)
        plt.savefig(save_path)
        plt.show()
    return

def main(args):
    print "Hello there you beautiful world you!"
    # dbD_all_log_break(*args[1:])
    # PA_all_log_break(*args[1:])
    double_dat_succ(*args[1:])
    return

##########################################
if __name__ == "__main__":
    main(sys.argv)





