#!/usr/bin/env python
# In case of poor (Sh***y) commenting contact adam.lamson@colorado.edu
# Basic
import sys, os, pdb
## Analysis
# import pandas as pd
import numpy as np
# import matplotlib.pyplot as plt
# import matplotlib as mpl
from math import *
from criteria_lib import *

from spindle_unit_dict import SpindleUnitDict
uc = SpindleUnitDict()

'''
Name: criteria_funcs.py
Description: Functions that classify spindle seed runs as successful or failed spindles
Input:
    1. timedata dictionary from SpindlePostAnalysis
    2. Dictionary of arguments to be used in the function
Output: Array of time steps where the spindle was considered successful
'''


def interpolar_fraction_threshold(timedata, **kwargs):

    # Set defaults if kwargs values are not set
    if 'thresh' not in kwargs: kwargs['thresh'] = .2
    if 'break_length' not in kwargs: kwargs['break_length'] = .2
    if 'duration' not in kwargs: kwargs['duration'] = 2.0
    if 'end_flag' not in kwargs: kwargs['end_flag'] = True

    time = timedata['time'] 
    if_ = [timedata['interpolar_fraction'][t] for t in time]

    # Return a list containing the start and end time of the successful spindle
    return get_start_end_time( time, if_, **kwargs)

def first_bipolar_formation_threshold(timedata, **kwargs):

    # Set defaults if kwargs values are not set
    if 'thresh' not in kwargs: kwargs['thresh'] = .2
    if 'break_length' not in kwargs: kwargs['break_length'] = .2
    if 'duration' not in kwargs: kwargs['duration'] = 2.0
    if 'end_flag' not in kwargs: kwargs['end_flag'] = True
    kwargs['first_bipolar'] = True

    time = timedata['time'] 
    if_ = [timedata['interpolar_fraction'][t] for t in time]

    # Return a list containing the start and end time of the successful spindle
    return get_start_end_time( time, if_, **kwargs)

def amphitelic_attachment_threshold(timedata, **kwargs):

    # Set defaults
    if 'namphi' not in kwargs: kwargs['namphi'] = 3
    if 'spindle_length' not in kwargs: kwargs['spindle_length'] = 1.0
    if 'duration' not in kwargs: kwargs['duration'] = 0.01 # Tiny amount, do not consider single spikes...
    if 'break_length' not in kwargs: kwargs['break_length'] = .2
    if 'end_flag' not in kwargs: kwargs['end_flag'] = False

    time = timedata['time']
    sl_ = np.asarray([timedata['spb_separation'][t]*(uc['um'][1]) for t in time])
    attach_arr = [timedata['kc_atypes'][t] for t in time]

    nchromo = len(attach_arr[0])
    atypeint = 4

    aa_ = np.zeros(len(attach_arr))

    for x in xrange(len(attach_arr)):
        for ic in xrange(nchromo):
            attach = attach_arr[x][ic]
            if attach == atypeint:
                aa_[x] += 1.0

    condition_ = np.logical_and(sl_ >= kwargs['spindle_length'], aa_ >= kwargs['namphi'])

    kwargs['thresh'] = 0.9
    retrval = get_start_end_time(time, condition_, **kwargs)
    return retrval

# Amphitelic and interpolar measure of succeess
# Amphitelic attachment must be had for some length of time
# Interpolar fraction above 0.2 for some length of time (same amount)
# Spindle length is greater than 1.05 microns
def amphitelic_attachment_interpolar_threshold(timedata, **kwargs):

    # Set defalts
    if 'namphi' not in kwargs: kwargs['namphi'] = 3
    if 'spindle_length' not in kwargs: kwargs['spindle_length'] = 1.0
    if 'duration' not in kwargs: kwargs['duration'] = 0.01 # Tiny amount, do not consider single spikes...
    if 'break_length' not in kwargs: kwargs['break_length'] = .2
    if 'end_flag' not in kwargs: kwargs['end_flag'] = False

    time = timedata['time']
    sl_ = np.asarray([timedata['spb_separation'][t]*(uc['um'][1]) for t in time])
    attach_arr = [timedata['kc_atypes'][t] for t in time]
    ip_arr = [timedata['interpolar_fraction'][t] for t in time]

    nchromo = len(attach_arr[0])
    atypeint = 4

    aa_ = np.zeros(len(attach_arr))
    ipa_ = np.zeros(len(ip_arr))

    for x in xrange(len(attach_arr)):
        for ic in xrange(nchromo):
            attach = attach_arr[x][ic]
            if attach == atypeint:
                aa_[x] += 1.0

    for x in xrange(len(ip_arr)):
        if ip_arr[x] >= 0.2:
            ipa_[x] += 1.0

    condition1_ = np.logical_and(sl_ >= kwargs['spindle_length'], aa_ >= kwargs['namphi'])
    condition2_ = np.logical_and(condition1_, ipa_)

    kwargs['thresh'] = 0.9
    retrval = get_start_end_time(time, condition2_, **kwargs)
    return retrval



##########################################
if __name__ == "__main__":
    print "Not implemented yet"




