#!/usr/bin/env python
# In case of poor (Sh***y) commenting contact adam.lamson@colorado.edu
# Basic
import sys, os, pdb
## Analysis
# import pandas as pd
import numpy as np
# import matplotlib.pyplot as plt
# import matplotlib as mpl
# from math import *

'''
Name: criteria_lib.py
Description:
Input:
Output:
'''

def get_start_end_time( time, array, duration, 
                        thresh, break_length, end_flag, **kwargs ):

        condition = np.abs(array) >= thresh

        # List of tuples with the start and stop indices of each segment of 
        # time where spindle is above required threshold
        segments = []
        # List of time durations of each segment
        segment_lengths = []
        prev_stop = -1
        max_time = -1.0
        # max_segment = (0,0)

        # loop over the regions and combine sections that dip down bellow
        # threshold for less than the break_length
        for start, stop in contiguous_regions(condition):
            stop -= 1 # Move the stop back one because this is where it broke
            # There was a dip that lasted shorter than the break time
            # ammend the previous segment to the current one
            if break_length > (time[start] - time[prev_stop]) and prev_stop != -1:
                segments[-1][1] = stop
                segment_lengths[-1] = time[segments[-1][1]-1] - time[segments[-1][0]]
            # A new segement occured so append it to the list of segments
            else:
                segments += [[start, stop]]
                segment_lengths += [ time[stop] - time[start] ] 

            prev_stop = stop

            if segment_lengths[-1] >= max_time: 
                max_time = segment_lengths[-1]
                max_segment = segments[-1]

        if 'first_bipolar' in kwargs and segments:
            success_spindle = segments[0]
            return success_spindle
        if 'chromosome_seconds' in kwargs and segments:
            success_spindle = segments
            return success_spindle
        elif end_flag and segments:
            if ((time[segments[-1][1]] == time[-1]) and
                    (segment_lengths[-1] >= duration)):
                success_spindle = segments[-1]
                return success_spindle
            else:
                return None 
        elif max_time >= duration:
            success_spindle = max_segment
            return success_spindle

        else:
            return None

def contiguous_regions(condition):
    """By Joe Kington, Finds contiguous True regions of the boolean array 
    "condition". Returns a 2D array where the first column is the start 
    index of the region and the second column is the end index.
    http://stackoverflow.com/questions/4494404/find-large-number-of-consecutive-values-fulfilling-condition-in-a-numpy-array"""

    # Find the indices of changes in "condition"
    d = np.diff(condition.astype(int))
    idx, = d.nonzero()

    # We need to start things after the change in "condition". Therefore,
    # we'll  shift the index by 1 to the right.
    idx += 1

    if condition[0]:
        # if the end of the start of condition is True prepend a 0
        idx = np.r_[0, idx]

    if condition[-1]:
        # if the end of condtion is True, append the length of the array
        idx = np.r_[idx, condition.size]

    idx.shape = (-1,2)
    return idx

##########################################
if __name__ == "__main__":
    print "Not implemented yet"




