#!/usr/bin/env python
# In case of poor (Sh***y) commenting contact adam.lamson@colorado.edu
# Basic
import sys, os, pdb
import yaml
import re
## Analysis
# import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
# from math import *
from spindle_unit_dict import SpindleUnitDict
## Image stuff
import cv2

'''
Name: spindle_movie.py
Description:
Input:
Output:
'''

##Class definition
# class class_name(object):
    # def __init__(self):
        # print "Not implemented yet"

def prep_seed_for_movie(work_dir):
    print 'prep_seed_for_movie not implemented.'
    # Make 

    return

def add_mask_to_frame(img, bkg, thresh=240):

    lower_white = np.array([thresh, thresh, thresh], dtype=np.uint8)
    upper_white = np.array([255, 255, 255], dtype=np.uint8)
    mask = cv2.inRange(img, lower_white, upper_white) # Get mask for spindle object
    mask = cv2.morphologyEx(mask, cv2.MORPH_OPEN, cv2.getStructuringElement(cv2.MORPH_ELLIPSE, (3, 3)))
    mask = cv2.bitwise_not(mask) # Invert mask for background

    fg_masked = cv2.bitwise_and(img, img, mask=mask)
    mask = cv2.bitwise_not(mask) # Invert mask for background
    bk_masked = cv2.bitwise_and(bkg, bkg, mask=mask)

    # Merge the fg and bk
    final = cv2.bitwise_or(fg_masked, bk_masked)
    # cv2.imshow('img',img)
    # cv2.imshow('mask',mask)

    return final


def get_time_str(frame_num, time_convert, param_dict):
    #Convert frame number to time in seconds
    tot_seconds = frame_num*param_dict["n_graph"]*param_dict["delta"]*time_convert
    
    minutes = int(tot_seconds/60)
    seconds = tot_seconds % 60
    # seconds = int(tot_seconds % 60)
    # remain = int((tot_seconds % 1)*100)

    # Create a string for time
    # minutes is always characters with 0 for place holder
    # seconds has 5 characters: two before the decimal (0 place holder),
    # two after the decimal, and the decimal is the final character.
    time_str = "{:02d}:{:04.1f}".format(minutes, seconds)
    return time_str

def annotate_frame(img, frame_str, size_factor=1600):
    cv2.putText(img, frame_str, (int(0.375*size_factor), int(0.90625*size_factor)), 
                cv2.FONT_HERSHEY_DUPLEX, 0.001875*size_factor, (0,0,0), int(.001875*size_factor), cv2.LINE_AA )
    return img

    # print "annotate_frame is not implemented yet."

def remove_prefix(text, prefix):
    if text.startswith(prefix):
        return text[len(prefix):]
    return text  # or whatever

def make_spindle_movie(work_dir, name='spindle_movie.mov',
                       default_file='spindle_bd_mp.default.yaml',
                       equil_file='spindle_bd_mp.equil.yaml',
                       posit_file='spindle_bd_mp.posit', fps=60.0,
                       frame_dir = 'frames/',
                       alt_frame_name = 'fixed',
                       compose_background = True,
                       do_anaphase = False,
                       anaphase_step = 0):

    fps = float(fps)
    uc = SpindleUnitDict()

    equil_dict = None 
    with open(equil_file, 'r') as df:
        equil_dict = yaml.load(df)

    # Init text writing
    font = cv2.FONT_HERSHEY_SIMPLEX

    mov_path = os.path.join(work_dir, name)
    if os.path.exists(mov_path):
        os.remove(mov_path)
    
    # Get necessary directory path names
    analysis_path = os.path.dirname(os.path.abspath(__file__))
    frame_dir = os.path.join(work_dir, frame_dir)

    # Format for video
    # fourcc = cv2.cv.FOURCC(*'mp4v')

    # Get background from files
    bkg = cv2.imread(os.path.join(analysis_path, 'ringed_background.png'))
    #bkg = cv2.imread(os.path.join(analysis_path, 'ringed_background_free.png'))

    # Make list of all the frames in the frame directory
    frame_list = [f for f in os.listdir(frame_dir) if os.path.isfile(os.path.join(frame_dir, f)) and f.startswith('frame')]
    frame_num_list = [ int(remove_prefix(re.findall(r'frame_\d+', f)[0], 'frame_')) for f in frame_list]
    from collections import OrderedDict
    frame_num_list = sorted(OrderedDict((x, True) for x in frame_num_list).keys())

    #print "anaphase_onset_step: {}".format(anaphase_step)
    anaphase_frame = anaphase_step / equil_dict['n_graph']
    anaphase_b_frame = np.rint(anaphase_frame + 120.0 / (equil_dict['n_graph'] * equil_dict['delta'] * uc['sec'][1]))
    print "anaphase_frame: {}".format(anaphase_frame)
    print "anaphase_b_frame: {}".format(anaphase_b_frame)

    # CJE Edit, remove the first frame always!!!1
    frame_list = frame_list[1:]
    frame_num_list = np.array(frame_num_list[1:])

    if do_anaphase:
        frame_num_list = frame_num_list[frame_num_list < anaphase_b_frame+2]
        #frame_list = frame_list[frame_num_list < anaphase_frame+1]

    #print frame_list
    #print frame_num_list

    vid = None
    size = None
    fps = 24.0 # must be a float

    #for f,n in zip(frame_list, frame_num_list):
    for n in frame_num_list:
        f = 'frame_{0:0>5d}.png'.format(n)
        img = cv2.imread(os.path.join(frame_dir, f))
        # Find the size of these frames if not defined
        if size is None:
            size = img.shape[1], img.shape[0]
        # Resize image to correct size if size was defined
        elif size[0] != img.shape[1] and size[1] != img.shape[0]:
            img = cv2.resize(img, size)
        if img.shape != bkg.shape:
            bkg = cv2.resize(bkg, size)
            size = img.shape[1], img.shape[0]
        if compose_background:
            bkg_img = add_mask_to_frame(img, bkg, thresh=200)
        else:
            bkg_img = img
        time = get_time_str(n-1, uc['sec'][1], equil_dict) 
        # print time. Assumes square image
        if compose_background:
            final_img = annotate_frame(bkg_img, time, size_factor=size[0])
        else:
            final_img = bkg_img

        frame_path = os.path.join(frame_dir, '{0}_{1:0>5}.png'.format(alt_frame_name, n))
        cv2.imwrite(frame_path, final_img)

        # final_img = cv2.resize(final_img, (size[1]/2, size[0]/2))
        # Initialize video writer at the beginning
        if vid is None:
            vid = cv2.VideoWriter(mov_path, cv2.VideoWriter_fourcc(*'mp4v'), fps, size)
        print "-- Frame number: {} --".format(n)
        # num += 1
        vid.write(bkg_img)
    return vid, anaphase_b_frame


def make_spindle_frame(frame_file):
    print "v1 called!";
    font = cv2.FONT_HERSHEY_SIMPLEX
    fourcc = cv2.cv.FOURCC(*'mp4v')

    analysis_path = os.path.dirname(os.path.abspath(__file__))

    bkg = cv2.imread(os.path.join(analysis_path, 'ringed_background.png'))
    img = None
    if os.path.exists(frame_file):
        img = cv2.imread(frame_file)
    else:
        raise IOError('{} does not exist'.format(
            os.path.abspath(frame_file) ) )

    size = img.shape[1], img.shape[0]
    if img.shape != bkg.shape:
        bkg = cv2.resize(bkg, size)
        # size = img.shape[1], img.shape[0]

    bkg_img = add_mask_to_frame(img, bkg, thresh=200)

    cv2.imwrite('{}_background.png'.format(frame_file), bkg_img)

    return

def make_spindle_frame(frame_file):
    print "v2 called!";
    # Init text writing
    font = cv2.FONT_HERSHEY_SIMPLEX

    # Get necessary directory path names
    analysis_path = os.path.dirname(os.path.abspath(__file__))

    # Format for video
    fourcc = cv2.cv.FOURCC(*'mp4v')

    # Get background from files
    bkg = cv2.imread(os.path.join(analysis_path, 'ringed_background.png'))

    img = cv2.imread(frame_file)
    size = img.shape[1], img.shape[0]

    if img.shape != bkg.shape:
        bkg = cv2.resize(bkg, size)
        size = img.shape[1], img.shape[0]

    bkg_img = add_mask_to_frame(img, bkg, thresh=200)
    cv2.imwrite("{}".format(frame_file), bkg_img)

def make_spindle_annotated_frame(frame_file, frame_num, equil_file):
    uc = SpindleUnitDict()
    equil_dict = None 
    with open(equil_file, 'r') as df:
        equil_dict = yaml.load(df)

    # Init text writing
    font = cv2.FONT_HERSHEY_SIMPLEX

    # Get necessary directory path names
    analysis_path = os.path.dirname(os.path.abspath(__file__))

    # Format for video
    fourcc = cv2.cv.FOURCC(*'mp4v')

    # Get background from files
    bkg = cv2.imread(os.path.join(analysis_path, 'ringed_background.png'))

    img = cv2.imread(frame_file)
    size = img.shape[1], img.shape[0]

    if img.shape != bkg.shape:
        bkg = cv2.resize(bkg, size)
        size = img.shape[1], img.shape[0]

    bkg_img = add_mask_to_frame(img, bkg, thresh=200)
    time = get_time_str(np.int_(frame_num), uc['sec'][1], equil_dict) 
    # print time. Assumes square image
    final_img = annotate_frame(bkg_img, time, size_factor=size[0])

    cv2.imwrite("moo_{}".format(frame_file), final_img)

def make_generic_movie(work_dir, name='spindle_movie.mov',
                       default_file='spindle_bd_mp.default.yaml',
                       equil_file='spindle_bd_mp.equil.yaml',
                       posit_file='spindle_bd_mp.posit', fps=60.0,
                       frame_dir = 'frames/'):

    fps = float(fps)
    uc = SpindleUnitDict()

    equil_dict = None 
    with open(equil_file, 'r') as df:
        equil_dict = yaml.load(df)

    # Init text writing
    font = cv2.FONT_HERSHEY_SIMPLEX

    mov_path = os.path.join(work_dir, name)
    if os.path.exists(mov_path):
        os.remove(mov_path)
    
    # Get necessary directory path names
    analysis_path = os.path.dirname(os.path.abspath(__file__))
    frame_dir = os.path.join(work_dir, frame_dir)

    # Format for video
    fourcc = cv2.cv.FOURCC(*'mp4v')

    # Make list of all the frames in the frame directory
    frame_list = [f for f in os.listdir(frame_dir) if os.path.isfile(os.path.join(frame_dir, f))]
    frame_num_list = [ int(re.findall(r'\d+', f)[0]) for f in frame_list]
    
    vid = None
    size = None
    fps = 60.0 # must be a float

    for f,n in zip(frame_list, frame_num_list):
        img = cv2.imread(os.path.join(frame_dir, f))
        # Find the size of these frames if not defined
        if size is None:
            size = img.shape[1], img.shape[0]
        # Resize image to correct size if size was defined
        elif size[0] != img.shape[1] and size[1] != img.shape[0]:
            img = cv2.resize(img, size)

        # Initialize video writer at the beginning
        if vid is None:
            vid = cv2.VideoWriter(mov_path, fourcc, fps, size)
        print "-- Frame number: {} --".format(n)
        # num += 1
        vid.write(img)
    return vid

##########################################
if __name__ == "__main__":
    make_spindle_frame(sys.argv[1])
    # work_dir = os.getcwd()
    # make_spindle_movie(work_dir)
    #make_spindle_annotated_frame(sys.argv[1], sys.argv[2], sys.argv[3])



