#!/usr/bin/env python
# In case of poor (Sh***y) commenting contact adam.lamson@colorado.edu
# Basic
import sys, os, pdb
## Analysis
# import pandas as pd
# import numpy as np
# import matplotlib.pyplot as plt
# import matplotlib as mpl
# from math import *

'''
Name:spindle_unit_dict.py
Description: Conversion dictionary for spindle seeds
Input: None
Output: None
'''

class SpindleUnitDict():
    def __init__(self):
        self.ud ={
            "sec" : ('(sec)', .0356, float), 
            "min" : ('(min)', .0356/60.0, float),
            "nm" : ('(nm)', 25.0, float), 
            "um" : ('($\mu$m)', .025, float), 
            "pN" : ('(pN)', 0.1644, float),
            "fr" : ('(min$^{-1}$)', 1685.39, float), # MT rescue frequency
            "fc" : ('(min$^{-1}$)', 1685.39, float), # MT catastrophe frequency
            "fcat" : ('(min$^{-1}$)', 1685.39, float), # MT catastrophe frequency
            "vs" : ('($\mu$m/min)', .025*1685.39, float), # MT shrinking velocity
            "vg" : ('($\mu$m/min)', .025*1685.39, float), # MT growing velocity
            "fmts" : ('(pN)', .1644, float), # MT stall force
            "fs" : ('(pN)', .1644, float), # MT stall force
            "NMw" : ('(pN)', .1644, float),
            "wf" : ('(pN)', .1644, float),
            "spbD" : ('($\mu$m$^{2}$/sec)', .025*.025*28.0899, float),
            "wt" : ('(sec)', .0356, float),
            "N" : ('', 1, int),
            "svs" : ('', 1.0, float),
            "svg" : ('', 1.0, float),
            "sfr" : ('', 1.0, float),
            "sfc" : ('', 1.0, float),
            "sL" : ('(nm)', 25.0, float),
            "afvs" : ('(pN)', 0.1644, float), # Stabilization force from chromosomes
            "afvg" : ('(pN)', 0.1644, float), # Stabilization force from chromosomes
            "affr" : ('(pN)', 0.1644, float), # Stabilization force from chromosomes
            "affc" : ('(pN)', 0.1644, float), # Stabilization force from chromosomes
            "bw" : ('', 1.0, float),
            "MTnum" : ('', 1, int),
            "pa"  : ('', 1.0, float),
            "epsS" : ('',1.0, float),
            "epsD" : ('',1.0, float),
            "eqL" : ('(nm)', 25.0, float), 
            "Ks" : ('(pN/nm)',.1644/25.0, float),
            "df" : ('($\mu$m$^{2}$/sec)', .025*.025*28.0899, float), 
            "dbS" : ('($\mu$m$^{2}$/sec)', .025*.025*28.0899, float), 
            "dbD" : ('($\mu$m$^{2}$/sec)', .025*.025*28.0899, float),
            "konS" : ('min$^{-1}$',1685.39, float),
            "konD" : ('min$^{-1}$',1685.39, float),
            "koffS" : ('min$^{-1}$',1685.39, float),
            "koffD" : ('min$^{-1}$',1685.39, float),
            "endP" : ('', 1.0, float),
            "aseN": ('', 1, int),
            "cutN": ('', 1, int),
            "klpN": ('', 1, int),
            "kr" : ('(pN nm/rad$^{2}$)', 0.1644*25.0, float),
            "lr" : ('(nm)', 25.0, float),
            "AFvel" : ('($\mu$m/min)', 0.025*1685.39, float),
            "afvel" : ('($\mu$m/min)', 0.025*1685.39, float),
            "Cmtfc" : ('(pN$^{-1}$)', 1.0/0.1644, float),
            "Cmt" : ('(pN nm)', 0.1644*25.0, float),
            "AFkm" : ('(pN/nm)', 0.1644/25.0, float),
            "AFrnot" : ('(nm)', 25.0, float),
            "AFkr" : ('(pN nm)', 0.1644*25.0, float), # AF angular spring
            #"AFkrF" : ('(pN nm)', 0.1644*25.0, float), # AF angular spring first prog lock
            #"AFkrS" : ('(pN nm)', 0.1644*25.0, float), # AF angular spring second prog lock
            #"AFkrT" : ('(pN nm)', 0.1644*25.0, float), # AF angular spring third prog lock
            #"AFkrR" : ('(pN nm)', 0.1644*25.0, float), # AF angular spring fourth prog lock
            "AFkrF" : ('(kT)', 1.0, float), # AF angular spring first prog lock
            "AFkrS" : ('(kT)', 1.0, float), # AF angular spring second prog lock
            "AFkrT" : ('(kT)', 1.0, float), # AF angular spring third prog lock
            "AFkrR" : ('(kT)', 1.0, float), # AF angular spring fourth prog lock
            "ChiC" : ('()', 1.0, float),
            "AFtkona" : ('(min$^{-1}$)', 1685.39, float),
            "AFtkond" : ('(min$^{-1}$)', 1685.39, float),
            "AFskon" : ('(min$^{-1}$)', 1685.39, float),
            "Tds" : ('', 1.0, float),
            "cutNxc" : ('(nm)', 25.0, float),
            "pklNxc" : ('(nm)', 25.0, float),
            "aseNxc" : ('(nm)', 25.0, float),
            "xca" : ('(nm)', 25.0, float),
            "xcd" : ('(nm)', 25.0, float),
            "xcs" : ('(nm)', 25.0, float),
            "CKc" : ('(pN/nm)', 0.1644/25.0, float),
            "CKu" : ('(pN nm rad$^{-2}$)', 0.1644*25.0, float),
            "CKv" : ('(pN nm rad$^{-2}$)', 0.1644*25.0, float),
            "dam" : ('()', 1.0, float), # Dam/DASH catastrophe multiplication factor
            "ABK" : ('()', 1.0, float), # Aurora B multiplcation factor for detachment
            "abk" : ('()', 1.0, float), # Aurora B multiplcation factor for detachment
            "Teff" : ('AU', 1.0, float), # MT tip effective concentration for chromosomes
            "Seff" : ('AU', 1.0, float), # MT side effective concentration for chromosomes
            "spbAng" : ('(rad)', 1.0, float),
            "tt" : ('AU', 1.0, float), # Tip tracking fraction
            "crnot" : ('(nm)', 25.0, float), # Chromatin rest length
            "naf" : ('N', 1.0, float), # Number of attachments
            "spbr" : ('(nm)', 25.0, float), # SPB post height
            "long" : ('(nm)', 25.0, float), # Long side of KC
            "short" : ('(nm)', 25.0, float), # Short side of KC
            "fdeps" : ('AU', 1.0, float), # SPECIAL version of the char distances to figure out what is going on and plot them appropriately
            "Ckr" : ('(kT)', 1.0, float), # Common angular potential on the SPB springs
            "abkf" : ('(pN)', 0.1644, float) # Force-dependence of Aurora B mechanisms
        }

    def __getitem__(self, k):
        if k in self.ud:
            return self.ud[k]
        else:
            return ('',1.0, float)

def ModifyXLabel(ax, p):
    if p == 'N':
        ax.set_xlabel(r'Number of Crosslinkers')
    elif p == 'svs':
        ax.set_xlabel(r'Shrinking Speed Stabilization Factor')
    elif p == 'svg':
        ax.set_xlabel(r'Growth Speed Stabilization Factor')
    elif p == 'sfr':
        ax.set_xlabel(r'Rescue Frequency Stabilization Factor')
    elif p == 'sfc':
        ax.set_xlabel(r'Catastrophe Frequency Stabilization Factor')
    elif p == 'sL':
        ax.set_xlabel(r'Stabilization Length ($\mu$m)')
    elif p == 'fc':
        ax.set_xlabel(r'Catastrophe Frequency (min$^{-1}$)')
    elif p == 'fcat':
        ax.set_xlabel(r'Catastrophe Frequency (min$^{-1}$)')
    elif p == 'fr':
        ax.set_xlabel(r'Rescue Frequency (min$^{-1}$)')
    elif p == 'vg':
        ax.set_xlabel(r'Growth Speed ($\mu$m/min)')
    elif p == 'vs':
        ax.set_xlabel(r'Shrinking Speed ($\mu$m/min)')
    elif p == 'wf':
        ax.set_xlabel(r'Asymptotic Wall Force (pN)')
    elif p == 'pa':
        ax.set_xlabel(r'Crosslinker Polar Affinity')
    elif p == 'bw':
        ax.set_xlabel(r'Barrier Weight')
    elif p == 'eqL':
        ax.set_xlabel(r'Crosslinker Equilibrium Length (nm)')
    elif p == 'Ks':
        ax.set_xlabel(r'Crosslinker Spring Constant (pN/nm)')
    elif p == 'df':
        ax.set_xlabel(r'Unbound Diffusion ($\mu$m$^2$/min)')
    elif p == 'dbS':
        ax.set_xlabel(r'Singly Bound Diffusion ($\mu$m$^2$/min)')
    elif p == 'dbD':
        ax.set_xlabel(r'Doubly Bound Diffusion ($\mu$m$^2$/min)')
    elif p == 'konS':
        ax.set_xlabel(r'Singly Bound On Rate (min$^{-1}$)')
    elif p == 'konD':
        ax.set_xlabel(r'Doubly Bound On Rate (min$^{-1}$)')
    elif p == 'koffS':
        ax.set_xlabel(r'Singly Bound Off Rate (min$^{-1}$)')
    elif p == 'koffD':
        ax.set_xlabel(r'Doubly Bound Off Rate (min$^{-1}$)')
    elif p == 'epsS':
        ax.set_xlabel(r'Single Binding Affinity')
    elif p == 'epsD':
        ax.set_xlabel(r'Double Binding Affinity')
    elif p == 'spbDiam':
        ax.set_xlabel(r'SPB Diameter ($\mu$m)')
    elif p == 'spbTheta':
        ax.set_xlabel(r'SPB Starting Theta Angle (rad)')
    elif p == 'kr':
        ax.set_xlabel(r'SPB Angular Spring Constant (pN nm/rad$^{2}$)')
    elif p == 'lr':
        ax.set_xlabel(r'SPB Angular Spring Radius of Curvature (nm)')
    elif p == 'endP':
        ax.set_xlabel(r'Singly.Doubly End Pausing (0 = off, 1 = on)')
    elif p == 'kr':
        ax.set_xlabel(r'SPB Angular Spring Constant')
    elif p == 'lr':
        ax.set_xlabel(r'SPB Radius of Curvature')
    elif p == 'cutN':
        ax.set_xlabel(r'Number of Kinesin-5 Motors')
    elif p == 'klpN':
        ax.set_xlabel(r'Number of Kinesin-14 Motors')
    elif p == 'aseN':
        ax.set_xlabel(r'Number of Ase1 Crosslinkers')
    elif p == 'AFvel':
        ax.set_xlabel(r'AF velocity ($\mu$m/min)')
    elif p == 'afvel':
        ax.set_xlabel(r'AF velocity ($\mu$m/min)')
    elif p == 'Cmtfc':
        ax.set_xlabel(r'Chromosome Catastrophe Enhancement (pN$^{-1}$)')
    elif p == 'Cmt':
        ax.set_xlabel(r'Chromatin repulsive amplitude (pN nm)')
    elif p == 'AFkm':
        ax.set_xlabel(r'AF Linear Spring (pN/nm)')
    elif p == 'AFrnot':
        ax.set_xlabel(r'AF Rest Length (nm)')
    elif p == 'AFkr':
        ax.set_xlabel(r'AF Angular Spring (pN nm)')
    elif p == 'AFkrF':
        ax.set_xlabel(r'First angular spring stiffness (kT)')
    elif p == 'AFkrS':
        ax.set_xlabel(r'Second angular spring stiffness (kT)')
    elif p == 'AFkrT':
        ax.set_xlabel(r'Third angular spring stiffness (kT)')
    elif p == 'AFkrR':
        ax.set_xlabel(r'Angular spring stiffness (kT)')
    elif p == 'ChiC':
        ax.set_xlabel(r'Angular Characteristic Distance ()')
    elif p == 'AFtkona':
        ax.set_xlabel(r'Tip On Rate Assembling (min$^{-1}$)')
    elif p == 'AFtkond':
        ax.set_xlabel(r'Tip On Rate Disassembling (min$^{-1}$)')
    elif p == 'AFskona':
        ax.set_xlabel(r'Side On Rate Assembling (min$^{-1}$)')
    elif p == 'AFskond':
        ax.set_xlabel(r'Side On Rate Disassembling (min$^{-1}$)')
    elif p == 'Tds':
        ax.set_xlabel(r'Thermal Diffusion Scale')
    elif p == 'cutNxc':
        ax.set_xlabel(r'Cut7 Characteristic Distance (nm)')
    elif p == 'pklNxc':
        ax.set_xlabel(r'Pkl1 Characteristic Distance (nm)')
    elif p == 'aseNxc':
        ax.set_xlabel(r'Ase1 Characteristic Distance (nm)')
    elif p == 'xca':
        ax.set_xlabel(r'AF Characteristic Distance Assemble (nm)')
    elif p == 'xcd':
        ax.set_xlabel(r'AF Characteristic Distance Disassemble (nm)')
    elif p == 'xcs':
        ax.set_xlabel(r'AF Characteristic Distance Side (nm)')
    elif p == 'CKc':
        ax.set_xlabel(r'Chromatin Spring Constant (pN/nm)')
    elif p == 'CKu':
        ax.set_xlabel(r'Chromatin Angular Spring Constant $\hat{\mathbf{u}}$ (pN nm rad$^{-2}$)')
    elif p == 'CKv':
        ax.set_xlabel(r'Chromatin Angular Spring Constant v (pN nm rad$^{-2}$)')
    elif p == 'dam':
        ax.set_xlabel(r'Kinetochore tip-enhanced catastrophe factor')
    elif p == 'ABK':
        ax.set_xlabel(r'Misaligned destabilization factor')
    elif p == 'abk':
        ax.set_xlabel(r'Misaligned destabilization factor')
    elif p == 'Teff':
        ax.set_xlabel(r'Tip Effective Concentration (AU)')
    elif p == 'Seff':
        ax.set_xlabel(r'Side Effective Concentration (AU)')
    elif p == 'spbAng':
        ax.set_xlabel(r'Angle separating SPBs')
    elif p == 'tt':
        ax.set_xlabel(r'Tip-tracking')
    elif p == 'crnot':
        ax.set_xlabel(r'Inter-KC rest length (nm)')
    elif p == 'naf':
        ax.set_xlabel(r'Number of Attachments')
    elif p == 'spbr':
        ax.set_xlabel(r'SPB Post Heigh (nm)')
    elif p == 'afvg':
        ax.set_xlabel(r'AF Grow Force Stabilization (pN)')
    elif p == 'afvs':
        ax.set_xlabel(r'AF Shrink Force Stabilization (pN)')
    elif p == 'affr':
        ax.set_xlabel(r'AF Rescue Force Stabilization (pN)')
    elif p == 'affc':
        ax.set_xlabel(r'AF Catastrophe Force Stabilization (pN)')
    elif p == 'long':
        ax.set_xlabel(r'Kinetochore length (nm)')
    elif p == 'Ckr':
        ax.set_xlabel(r'SPB attachment angular spring (kT)')
    elif p == 'abkf':
        ax.set_xlabel(r'Characteristic force (pN)')
    elif p == 'ikctension':
        ax.set_xlabel(r'Interkinetochore tension (pN)')
    else:
        print "Parameter {} not set in spindle_run".format(p)
        ax.set_xlabel(p)
    return

##########################################
if __name__ == "__main__":
    print "Not implemented yet"




