#!/usr/bin/env python
# In case of poor (Sh***y) commenting contact adam.lamson@colorado.edu
# Basic
import sys, os, pdb
import pickle
## Analysis
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
from math import *

sys.path.append(os.path.join(os.path.dirname(__file__), '..', 'Lib'))
sys.path.append(os.path.join(os.path.dirname(__file__), '..', 'Spindle'))
from base_funcs import moving_average
from spindle_unit_dict import SpindleUnitDict
from read_posit_chromosomes import ReadPositChromosomes
from msd_engine import MSDEngine

'''
Name: ChromosomeDiffusionAnalysis.py
Description:
Input:
Output:
'''

#Class definition
class ChromosomeDiffusionAnalysis(object):
    def __init__(self, run_dir_path, uc=None, nsteps=1000000, nposit=100000, delta=0.00025, name="gen_chromosomes_diffusion.yaml"):
        self.run_dir_path = os.path.realpath(run_dir_path)
        self.chromosomereader = ReadPositChromosomes(run_dir_path, "chromosomes.posit", name, name)
        self.chromosomereader.LoadPosit()
        self.uc = uc

        self.nposit = nposit
        self.nsteps = self.chromosomereader.CheckDefaultThenEquil('nsteps')
        self.delta = self.chromosomereader.CheckDefaultThenEquil('delta')

        self.msdengine = MSDEngine(ndim=3, nframes=(self.nsteps/self.nposit), nposit=self.nposit, delta=self.delta, uc=self.uc)

    def Analyze(self):
        for frame in xrange(self.nsteps/self.nposit):
            print "frame: {}".format(frame)
            self.chromosomereader.ReadFramePosit()
            #self.chromosomereader.PrintFrame()

            if frame == 0:
                self.msdengine.InitChromosomes(self.chromosomereader)
            else:
                self.msdengine.CalcMSDChromo(frame, self.chromosomereader)

    def GraphMSD(self, ax, label):
        self.msdengine.GraphMSD_Chromosomes_Trans(ax, label)

            

##########################################
if __name__ == "__main__":
    uc = SpindleUnitDict()
    c = ChromosomeDiffusionAnalysis(sys.argv[1], uc)
    c.Analyze()

    fig, ax = plt.subplots()
    c.GraphMSD(ax=ax, label=None)
    plt.show()
