#!/usr/bin/env python
# In case of poor (Sh**y) commenting contact christopher.edelmaier@colorado.edu
# Basic
import sys, os, pdb
import gc
import argparse
import fnmatch
## Analysis
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import matplotlib as mpl

sys.path.append(os.path.join(os.path.dirname(__file__), '..', 'Lib'))
sys.path.append(os.path.join(os.path.dirname(__file__), '..', 'Spindle'))

from correlationdata import CorrelationData

'''
Name: ChromosomeDistributinos.py
Description:
Input:
Output:
'''

def parse_args():
    parser = argparse.ArgumentParser(prog='ChromosomeDistributions.py')

    # General options that are actually required
    parser.add_argument('-l', '--length', required=True, type=str,
            help='Microtubule length')
    parser.add_argument('-f','--filename', required=True, type=str,
            help='Filename')

    opts = parser.parse_args()
    return opts

# Class definition
class ChromosomeDistributions(object):
    def __init__(self, opts):
        self.opts = opts
        self.cwd = os.getcwd()

        self.ReadOpts()

    # Read in options
    def ReadOpts(self):
        self.correlation_data = CorrelationData(self.cwd, self.opts.filename)
        self.correlation_data.Print()

        self.mt_length = np.float_(self.opts.length)
        self.basefile = os.path.splitext(os.path.basename(self.opts.filename))[0]

    # Plot the data
    def PlotData(self):
        norm_data = self.correlation_data.NormalizeData()
        print "norm_data: {}".format(norm_data)
        # Change x units to nm
        x = np.zeros(len(norm_data))
        for i in xrange(len(x)):
            x[i] = i * self.correlation_data.bin_size * 25.0
        print x
        fig, ax = plt.subplots()
        ax.plot(x, norm_data)
        ax.set_ylabel(r'Probability')
        ax.set_xlabel(r'MT position (nm)')
        fig.tight_layout()
        fig.savefig(self.basefile + '.pdf', dip=fig.dpi)


if __name__ == "__main__":
    opts = parse_args()
    x = ChromosomeDistributions(opts)
    x.PlotData()
