#!/usr/bin/env python
# In case of poor (Sh**y) commenting contact adam.lamson@colorado.edu
# Basic
import sys, os, pdb
import gc
from collections import OrderedDict
## Analysis
sys.path.append(os.path.join(os.path.dirname(__file__), '..', '..', '..', 'Lib'))
from stylelib.ase1_styles import cp_spindle_stl

import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
from mpl_toolkits.axes_grid1 import make_axes_locatable
import itertools
# from math import *

# This is a oneoff, just make the damn plot!
plt.style.use(cp_spindle_stl)
mpl.rcParams['font.serif'] = 'Arial'
mpl.rcParams['font.sans-serif'] = 'Arial'
fig, ax = plt.subplots(figsize=(5.0, 2.5))

x_vals = [1, 2, 3]
y_vals = [0.104023347925787, 0.6245570148009173, 0.6811027725661872]
y_errs = [0.010946190058149641, 0.039747583194646025, 0.053768212377079745]
xtick_names = ['F-independent\nkinetics', 'F-dependent\nshrinking MT', 'F-dependent\nall']

#ax.scatter(x_vals, y_vals, zorder=100, s=50, marker='s', color='k', label=None, facecolors='none')
#ax.errorbar(x_vals, y_vals, y_errs, ecolor='k', elinewidth=2, capsize=5, capthick=1, zorder=0, fmt='none', marker='s')
ax.bar(x_vals, y_vals, color='gray', edgecolor='k', yerr=y_errs, capsize=5, width=0.5)

ax.set_ylim(0.0, 1.0)
ax.set_ylabel(r'Fraction simultaneous biorientation')
plt.xticks(x_vals, xtick_names, rotation=0)

fig.tight_layout()
plt.savefig('fig3_forcedep.pdf', dpi=fig.dpi)
plt.close()
