#!/usr/bin/env python
# In case of poor (Sh**y) commenting contact adam.lamson@colorado.edu
# Basic
import sys, os, pdb
import gc
from collections import OrderedDict
## Analysis
sys.path.append(os.path.join(os.path.dirname(__file__), '..', '..', '..', 'Lib'))
from stylelib.ase1_styles import cp_spindle_stl

import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
from mpl_toolkits.axes_grid1 import make_axes_locatable
import itertools
# from math import *

# This is a oneoff, just make the damn plot!
plt.style.use(cp_spindle_stl)
mpl.rcParams['font.serif'] = 'Arial'
mpl.rcParams['font.sans-serif'] = 'Arial'
fig, ax = plt.subplots(figsize=(2.75, 2.0))

x_vals = [1, 2, 3]
y_vals = [0.139345215944, 0.00542373285377, 0.234698535409]
y_errs = [0.056357821417, 0.00447074564941, 0.0545244801431]
xtick_names = ['Reference', 'Restricted', 'Weak\nrescue']
#x_vals = [1, 2, 3, 4, 5]
#y_vals = [0.139345215944, 0.00542373285377, 0.234698535409, 0.287436816841, 0.225300476421]
#y_errs = [0.056357821417, 0.00447074564941, 0.0545244801431, 0.0345237073435, 0.0482709435687]
#xtick_names = ['Reference', 'Restricted', 'Weak rescue', 'Permissive', 'ABK']

#ax.scatter(x_vals, y_vals, zorder=100, s=50, marker='s', color='k', label=None, facecolors='none')
ax.bar(x_vals, y_vals, color='gray', edgecolor='k', yerr=y_errs, capsize=5)
#ax.errorbar(x_vals, y_vals, y_errs, ecolor='k', elinewidth=2, capsize=5, capthick=1, zorder=0, fmt='none', marker='s')

ax.set_ylim(0.0, 0.3)
ax.set_ylabel('Length fluctuation ($\mu$m)')
plt.xticks(x_vals, xtick_names, rotation=0)

fig.tight_layout()
plt.savefig('fig4_fluctuations.pdf', dpi=fig.dpi)
plt.close()
