#!/usr/bin/env python
# In case of poor (Sh**y) commenting contact adam.lamson@colorado.edu
# Basic
import sys, os, pdb
import gc
from collections import OrderedDict
## Analysis
sys.path.append(os.path.join(os.path.dirname(__file__), '..', '..', '..', 'Lib'))
from stylelib.ase1_styles import cp_spindle_stl

import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
from mpl_toolkits.axes_grid1 import make_axes_locatable
import itertools
# from math import *

# This is a oneoff, just make the damn plot!
plt.style.use(cp_spindle_stl)
mpl.rcParams['font.serif'] = 'Arial'
mpl.rcParams['font.sans-serif'] = 'Arial'
fig, ax = plt.subplots(figsize=(3.0, 2.166666666))

# length fluctuations and errors
fluctuations = [0.220590349, 0.267021431, 0.242305187, 0.256806691, 0.18162718, 0.236555659, 0.221531727, 0.189419795, 0.202568176, 0.134299291, 0.183143845, 0.137821751, 0.110408915, 0.02876677, 0.032012589, 0.028920333, 0.013789873]
fluctuations_error = [0.029092154, 0.034817535, 0.040646787, 0.045643122, 0.033218845, 0.033749892, 0.04338423, 0.032206923, 0.043628885, 0.030372752, 0.034072209, 0.033161264, 0.040344062, 0.0114626, 0.013133121, 0.011784413, 0.006700324]
lifetimes = [0.273529775, 0.191883104, 0.175351561, 0.165947027, 0.151632427, 0.146421649, 0.143027957, 0.1354739, 0.122817014, 0.099802019, 0.09943029, 0.094679807, 0.079464497, 0.062703513, 0.060923257, 0.058529923, 0.053855591]
lifetimes_error = [0.009787701, 0.005220981, 0.004876447, 0.004375528, 0.003994258, 0.004149509, 0.003453293, 0.003407211, 0.002742544, 0.002036868, 0.002056026, 0.001893344, 0.001295437, 0.000754343, 0.000772266, 0.000671576, 0.000563501]
colors = ['k', 'k', 'k', 'k', 'k', 'k', 'k', 'k', 'k', 'k', 'k', 'k', 'k', 'k', 'k', 'k', 'k']

ikc_stretch = [0.512747825, 0.409714205, 0.429787434, 0.435214844, 0.398360263, 0.422056079, 0.410260288, 0.402362453, 0.361805026, 0.379082085, 0.337929445, 0.337947116, 0.23252855, 0.202877365, 0.213556067, 0.201978206, 0.170503783]
ikc_stretch_err = [0.023335906, 0.026459495, 0.026213118, 0.025224678, 0.027218881, 0.02776557, 0.027613699, 0.026077077, 0.027539311, 0.028157677, 0.026779863, 0.027332542, 0.023912568, 0.021414246, 0.023037483, 0.021570537, 0.02021986]
#fluctuations = [0.242305187, 0.256806691, 0.18162718, 0.236555659, 0.221531727, 0.189419795, 0.202568176, 0.134299291, 0.183143845, 0.137821751]
#fluctuations_error = [0.040646787, 0.045643122, 0.033218845, 0.033749892, 0.04338423, 0.032206923, 0.043628885, 0.030372752, 0.034072209, 0.033161264]
#lifetimes = [0.175351561, 0.165947027, 0.151632427, 0.146421649, 0.143027957, 0.1354739, 0.122817014, 0.099802019, 0.09943029, 0.094679807]
#lifetimes_error = [0.004876447, 0.004375528, 0.003994258, 0.004149509, 0.003453293, 0.003407211, 0.002742544, 0.002036868, 0.002056026, 0.001893344]

ax.scatter(x = lifetimes, y = fluctuations, zorder=100, s=10, marker='s', color=colors, label=None, facecolors='none')
#ax.errorbar(x = lifetimes, y = fluctuations, yerr = fluctuations_error, xerr = lifetimes_error, ecolor='k', elinewidth=2, capsize=5, capthick=1, zorder=0, fmt='none', marker='s')
# Have to plot the errorbars individually if we wnat to color them properly
for xx, yy, yyerr, xxerr, color in zip(lifetimes, fluctuations, fluctuations_error, lifetimes_error, colors):
    ax.errorbar(x = xx, y = yy, yerr = yyerr, xerr = xxerr, ecolor = color, elinewidth=2, capsize=5, capthick=1, zorder=0, fmt='none', marker='s')

ax.set_ylabel('Length fluctuation ($\mu$m)')
ax.set_xlabel('Kinetochore-microtubule\nattachment lifetime (min)')
ax.set_ylim((0.0, 0.35))

fig.tight_layout()
plt.savefig('kmt_lifetime_vs_fluctuations.pdf', dpi=fig.dpi)
plt.close()

fig, ax = plt.subplots(figsize=(3.0, 2.166666666))
ax.scatter(x = lifetimes, y = ikc_stretch, zorder=100, s=10, marker='s', color = colors, label=None, facecolors='none')
for xx, yy, yyerr, xxerr, color in zip(lifetimes, ikc_stretch, ikc_stretch_err, lifetimes_error, colors):
    ax.errorbar(x = xx, y = yy, yerr = yyerr, xerr = xxerr, ecolor = color, elinewidth=2, capsize=5, capthick=1, zorder=0, fmt='none', marker='s')

ax.set_ylabel('Avg. late kinetochore separation ($\mu$m)')
ax.set_xlabel('Kinetochore-microtubule\nattachment lifetime (min)')

fig.tight_layout()
plt.savefig('kmt_lifetime_vs_kcstretch.pdf', dpi=fig.dpi)
plt.close()

fig, ax = plt.subplots(figsize=(3.0, 2.166666666))
ax.scatter(x = fluctuations, y = ikc_stretch, zorder=100, s=10, marker='s', color = colors, label=None, facecolors='none')
for xx, yy, yyerr, xxerr, color in zip(fluctuations, ikc_stretch, ikc_stretch_err, fluctuations_error, colors):
    ax.errorbar(x = xx, y = yy, yerr = yyerr, xerr = xxerr, ecolor = color, elinewidth=2, capsize=5, capthick=1, zorder=0, fmt='none', marker='s')

ax.set_xlabel('Length fluctuation ($\mu$m)')
ax.set_ylabel('Avg. late kinetochore sepaation ($\mu$m)')

fig.tight_layout()
plt.savefig('kmt_fluctuations_vs_kcstretch.pdf', dpi=fig.dpi)
plt.close()

# Try to do everything as a single plot with the color being the inter-kinetochore distance
fig, ax = plt.subplots(figsize=(4.0, 2.166666666))
max_stretch = max(ikc_stretch)
# Override max_stretch
max_stretch = 0.55
colors = mpl.cm.rainbow(np.asarray(ikc_stretch)/max_stretch)
ax.scatter(x = lifetimes, y = fluctuations, zorder=100, s=10, marker='s', color=colors, label=None)
for xx, yy, yyerr, xxerr, color in zip(lifetimes, fluctuations, fluctuations_error, lifetimes_error, colors):
    ax.errorbar(x = xx, y = yy, yerr = yyerr, xerr = xxerr, ecolor = color, elinewidth=2, capsize=5, capthick=1, zorder=0, fmt='none', marker='s')

ax.set_xlabel('Kinetochore-microtubule\nattachment lifetime (min)')
ax.set_ylabel('Length fluctuation ($\mu$m)')

# Create the colorbar by hand
divider = make_axes_locatable(ax)
cax = divider.append_axes('right', size='5%', pad=0.1)
v_min = 0.0
v_max = max_stretch
cb = mpl.colorbar.ColorbarBase(cax, cmap=mpl.cm.rainbow, norm=mpl.colors.Normalize(vmin=v_min, vmax=v_max))
cb.set_label('Average inter-kinetochore\ndistance ($\mu$m)')

fig.tight_layout()
plt.savefig('kmt_fluctuations_lifetimes_stretch.pdf', dpi=fig.dpi)
plt.close()
