#!/usr/bin/env python
# In case of poor (Sh**y) commenting contact adam.lamson@colorado.edu
# Basic
import sys, os, pdb
import gc
from collections import OrderedDict
## Analysis
sys.path.append(os.path.join(os.path.dirname(__file__), '..', '..', '..', 'Lib'))
from stylelib.ase1_styles import cp_spindle_stl

import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
from mpl_toolkits.axes_grid1 import make_axes_locatable
import itertools
# from math import *

# This is a oneoff, just make the damn plot!
plt.style.use(cp_spindle_stl)
mpl.rcParams['font.serif'] = 'Arial'
mpl.rcParams['font.sans-serif'] = 'Arial'
fig, ax = plt.subplots(figsize=(2.5, 2.166666666))

# length fluctuations and errors
#fluctuations = [0.139345215944, 0.00542373285377, 0.234698535409]
#fluctuations_error = [0.056357821417, 0.00447074564941, 0.0545244801431]
#lifetimes = [0.142497052071, 0.0434020491858, 0.189982685541]
#lifetimes_error= [0.00507145385753, 0.000870419259575, 0.00884847360529]
#colors = ['r', 'k', 'k']

fluctuations = [0.221531727, 0.00323626, 0.295419748]
fluctuations_error = [0.04338423, 0.002235398, 0.041654265]
lifetimes = [0.143027957, 0.04435914, 0.183790405]
lifetimes_error = [0.003453293, 0.000669271, 0.005631774]
ikc_stretch = [0.410260288, 0.122477656, 0.541217395]
ikc_stretch_err = [0.027613699, 0.020149621, 0.026211923]
colors = ['r', 'k', 'k']

ax.scatter(x = lifetimes, y = fluctuations, zorder=100, s=10, marker='s', color=colors, label=None, facecolors='none')
#ax.errorbar(x = lifetimes, y = fluctuations, yerr = fluctuations_error, xerr = lifetimes_error, ecolor='k', elinewidth=2, capsize=5, capthick=1, zorder=0, fmt='none', marker='s')
# Have to plot the errorbars individually if we wnat to color them properly
for xx, yy, yyerr, xxerr, color in zip(lifetimes, fluctuations, fluctuations_error, lifetimes_error, colors):
    ax.errorbar(x = xx, y = yy, yerr = yyerr, xerr = xxerr, ecolor = color, elinewidth=2, capsize=5, capthick=1, zorder=0, fmt='none', marker='s')

ax.set_ylabel('Length fluctuation ($\mu$m)')
ax.set_xlabel('Kinetochore-microtubule\nattachment lifetime (min)')
ax.set_ylim((0.0, 0.35))

fig.tight_layout()
plt.savefig('ref_rest_weak_lifetimes_fluctuations.pdf', dpi=fig.dpi)
plt.close()

# Try to do everything as a single plot with the color being the inter-kinetochore distance
fig, ax = plt.subplots(figsize=(2.0, 2.166666666))
max_stretch = max(ikc_stretch)
# Override max_stretch
max_stretch = 0.55
colors = mpl.cm.rainbow(np.asarray(ikc_stretch)/max_stretch)
ax.scatter(x = lifetimes, y = fluctuations, zorder=100, s=10, marker='s', color=colors, label=None)
for xx, yy, yyerr, xxerr, color in zip(lifetimes, fluctuations, fluctuations_error, lifetimes_error, colors):
    ax.errorbar(x = xx, y = yy, yerr = yyerr, xerr = xxerr, ecolor = color, elinewidth=2, capsize=5, capthick=1, zorder=0, fmt='none', marker='s')

ax.set_xlabel('Kinetochore-microtubule\nattachment lifetime (min)')
ax.set_ylabel('Length fluctuation ($\mu$m)')

## Create the colorbar by hand
#divider = make_axes_locatable(ax)
#cax = divider.append_axes('right', size='5%', pad=0.1)
#v_min = 0.0
#v_max = max_stretch
#cb = mpl.colorbar.ColorbarBase(cax, cmap=mpl.cm.rainbow, norm=mpl.colors.Normalize(vmin=v_min, vmax=v_max))
#cb.set_label('Average inter-kinetochore\ndistance ($\mu$m)')

fig.tight_layout()
plt.savefig('refrestweak_kmt_fluctuations_lifetimes_stretch.pdf', dpi=fig.dpi)
plt.close()
